/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.Node;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.nio.NIOListener;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.nio.NIOProperties;
import es.bsc.comm.nio.event.NIOEvent;
import es.bsc.comm.nio.event.NewTransferEvent;
import es.bsc.comm.transfers.ReceiveTransfer;
import es.bsc.comm.transfers.SendTransfer;
import es.bsc.comm.transfers.ShutdownTransfer;
import es.bsc.comm.transfers.Transfer;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class NIOConnection
implements Connection,
InternalConnection {
    private static final Logger LOGGER = Logger.getLogger("Communication");
    private static final HashMap<SocketChannel, NIOConnection> OPEN_CHANNELS = new HashMap();
    private SocketChannel sc;
    private int conRetries = 0;
    private boolean paused;
    private Transfer currentTransfer;
    private final LinkedList<Transfer> pendingTransfers;
    private final LinkedList<ByteBuffer> receiveBuffer;
    private final LinkedList<ByteBuffer> sendBuffer;
    private final NIONode node;
    private boolean closedSocket;
    private boolean closedConnection;
    protected EventManager em;

    public NIOConnection(NIOEventManager ntm, SocketChannel sc, NIONode n) {
        this.em = ntm;
        this.currentTransfer = null;
        this.pendingTransfers = new LinkedList();
        this.node = n;
        this.receiveBuffer = new LinkedList();
        this.sendBuffer = new LinkedList();
        this.closedSocket = false;
        this.closedConnection = false;
        this.registerChannel(sc);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void sendCommand(Object cmd) {
        SendTransfer t = new SendTransfer(Transfer.Type.COMMAND, cmd);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void sendDataFile(String name) {
        SendTransfer t = new SendTransfer(name);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void sendDataObject(Object o) {
        SendTransfer t = new SendTransfer(Transfer.Type.DATA, o);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void sendDataArray(byte[] array) {
        SendTransfer t = new SendTransfer(Transfer.Type.DATA, array);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receive() {
        ReceiveTransfer t = new ReceiveTransfer();
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receive(String name) {
        ReceiveTransfer t = new ReceiveTransfer();
        t.setReceptionDefaultFileName(name);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receiveDataObject() {
        ReceiveTransfer t = new ReceiveTransfer(Transfer.Destination.OBJECT);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receiveDataArray() {
        ReceiveTransfer t = new ReceiveTransfer(Transfer.Destination.ARRAY);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receiveDataFile(String name) {
        ReceiveTransfer t = new ReceiveTransfer(Transfer.Destination.FILE);
        t.setReceptionDefaultFileName(name);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void finishConnection() {
        ShutdownTransfer t = new ShutdownTransfer();
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void requestTransfer(Transfer t) {
        LOGGER.debug("Requesting transfer " + t + " on connection " + this.hashCode());
        this.pendingTransfers.add(t);
        if (this.currentTransfer == null) {
            this.handleNextTransfer();
        }
    }

    @Override
    public void receivedPacket(ByteBuffer buffer) {
        this.receiveBuffer.add(buffer);
        if (this.currentTransfer != null) {
            this.progressCurrentTransfer();
        }
    }

    @Override
    public void lowSendBuffer() {
        if (this.currentTransfer != null) {
            this.progressCurrentTransfer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emptySendBuffer() {
        if (this.currentTransfer != null && this.currentTransfer.isComplete() && this.currentTransfer.getDirection() == Transfer.Direction.SEND) {
            boolean emptyBuffer;
            LinkedList<ByteBuffer> linkedList = this.sendBuffer;
            synchronized (linkedList) {
                emptyBuffer = this.sendBuffer.isEmpty();
            }
            if (emptyBuffer) {
                this.currentTransfer.notifyCompletion(this, this.em);
                this.handleNextTransfer();
            }
        }
    }

    @Override
    public void closedChannel() {
        LOGGER.debug("Channel on connection " + this.hashCode() + " has been closed");
        this.closedSocket = true;
        if (this.currentTransfer != null) {
            this.currentTransfer.notifyError(this, this.em, new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, (Throwable)new Exception("Channel was already closed for connection " + this.hashCode())));
            this.handleNextTransfer();
        }
        if (this.closedConnection) {
            this.unregisterChannel();
            this.em.connectionFinished(this);
        }
    }

    public void closeConnection() {
        LOGGER.debug("Requesting connection " + this.hashCode() + " closure");
        if (!this.closedSocket) {
            NIOListener.closeSocket(this.sc);
        } else if (!this.closedConnection) {
            this.unregisterChannel();
            this.em.connectionFinished(this);
        }
        this.closedConnection = true;
        this.handleNextTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(SocketChannel socket) {
        this.sc = socket;
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            OPEN_CHANNELS.put(this.sc, this);
        }
        LOGGER.debug("Associating Socket: " + this.sc.hashCode() + "; with connection: " + this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterChannel() {
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            OPEN_CHANNELS.remove(this.sc);
        }
        this.sc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceChannel(SocketChannel newSocket) {
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            OPEN_CHANNELS.remove(this.sc);
            OPEN_CHANNELS.put(newSocket, this);
        }
        this.sc = newSocket;
    }

    private void handleNextTransfer() {
        if (this.paused) {
            return;
        }
        if (!this.pendingTransfers.isEmpty()) {
            this.currentTransfer = this.pendingTransfers.removeFirst();
            LOGGER.debug("NIOConnection " + this.hashCode() + " takes " + this.currentTransfer);
            if (this.currentTransfer.isShutdown()) {
                this.closeConnection();
            } else {
                this.startCurrentTransfer();
            }
        } else {
            this.currentTransfer = null;
        }
    }

    private void pause() {
        LOGGER.debug("Transfer " + this.currentTransfer + " on connection " + this.hashCode() + " is paused.");
        this.paused = true;
        this.currentTransfer.pause(this);
    }

    @Override
    public void resume() {
        LOGGER.debug("Resume transfer " + this.currentTransfer + " on connection " + this.hashCode() + ".");
        this.paused = false;
        this.startCurrentTransfer();
    }

    private void startCurrentTransfer() {
        try {
            if (this.currentTransfer.checkViability(this.closedSocket, this.receiveBuffer, this.sendBuffer)) {
                this.currentTransfer.start(this.receiveBuffer, this.sendBuffer);
                this.progressCurrentTransfer();
            } else {
                this.pause();
            }
        }
        catch (NIOException ne) {
            LOGGER.debug("Connection closed before completing transfer " + this.currentTransfer);
            this.currentTransfer.notifyError(this, this.em, ne);
            this.handleNextTransfer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressCurrentTransfer() {
        if (this.paused) {
            return;
        }
        long progress = this.currentTransfer.progress(this.receiveBuffer, this.sendBuffer);
        if (this.currentTransfer.getDirection() == Transfer.Direction.RECEIVE) {
            if (progress == 0L) {
                this.currentTransfer.notifyCompletion(this, this.em);
                this.handleNextTransfer();
            } else if (this.closedSocket) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Connection closed before completing transfer " + this.currentTransfer);
                }
                this.currentTransfer.notifyError(this, this.em, new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, (Throwable)new Exception("Channel was already closed for connection " + this)));
                this.handleNextTransfer();
            }
        } else {
            LinkedList<ByteBuffer> linkedList = this.sendBuffer;
            synchronized (linkedList) {
                if (!this.sendBuffer.isEmpty()) {
                    NIOListener.changeInterest(this.sc, 4);
                }
            }
        }
    }

    @Override
    public void error(CommException exception) {
        NIOException ne = (NIOException)exception;
        if (ne.getError() == NIOException.ErrorType.FINISHING_CONNECTION) {
            if (ne.getCause() instanceof SocketTimeoutException) {
                ++this.conRetries;
                if (this.conRetries < NIOProperties.MAX_RETRIES) {
                    SocketChannel sc = NIOListener.restartConnection(this.node);
                    this.replaceChannel(sc);
                } else {
                    this.closedSocket = true;
                    this.unregisterChannel();
                }
            } else {
                this.closedSocket = true;
                this.unregisterChannel();
            }
        } else {
            this.currentTransfer.notifyError(this, this.em, exception);
            this.handleNextTransfer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NIOConnection getConnection(SocketChannel sc) {
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            return OPEN_CHANNELS.get(sc);
        }
    }

    public static Collection<SocketChannel> getAllSockets() {
        return OPEN_CHANNELS.keySet();
    }

    public static boolean areAliveConnections() {
        return !OPEN_CHANNELS.isEmpty();
    }

    public LinkedList<ByteBuffer> getSendBuffer() {
        return this.sendBuffer;
    }

    public Transfer getCurrentTransfer() {
        return this.currentTransfer;
    }

    public boolean isOwnerFor(NIOEvent event) {
        if (event.getConnection() != null) {
            return event.getConnection() == this;
        }
        return event.getSocket() == this.sc;
    }

    public SocketChannel getSocket() {
        return this.sc;
    }
}

