/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.transfers;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.nio.NIOProperties;
import es.bsc.comm.transfers.Transfer;
import es.bsc.comm.util.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class ReceiveTransfer
extends Transfer {
    private static int tokens = NIOProperties.MAX_RECEIVES;
    private static LinkedList<InternalConnection> pausedConnections = new LinkedList();
    private boolean destInit;
    private OutputStream streamOut;

    public ReceiveTransfer() {
        this.remainingSize = 0L;
        this.destInit = false;
    }

    public ReceiveTransfer(Transfer.Destination destination) {
        this.type = Transfer.Type.DATA;
        this.destination = destination;
        this.destInit = true;
    }

    public ReceiveTransfer(Transfer.Type type) {
        this.type = type;
        this.destination = Transfer.Destination.OBJECT;
        this.destInit = false;
    }

    private boolean initTransfer(LinkedList<ByteBuffer> receivedValues) throws FileNotFoundException {
        ByteBuffer bb = receivedValues.removeFirst();
        while (bb.remaining() < 16 && !receivedValues.isEmpty()) {
            ByteBuffer next = receivedValues.removeFirst();
            ByteBuffer bb2 = ByteBuffer.allocate(bb.remaining() + next.remaining());
            bb2.put(bb);
            bb2.put(next);
            bb2.flip();
            bb = bb2;
        }
        if (bb.remaining() < 16) {
            receivedValues.addFirst(bb);
            return false;
        }
        long size = bb.getLong();
        if (!this.destInit) {
            this.destInit = true;
            this.type = Transfer.Type.values()[bb.getInt()];
            this.destination = Transfer.Destination.values()[bb.getInt()];
        } else {
            bb.position(bb.position() + 8);
        }
        this.setSize(size);
        this.openStream();
        if (bb.remaining() > 0) {
            receivedValues.addFirst(bb);
        }
        return true;
    }

    private void openStream() throws FileNotFoundException {
        this.streamOut = this.destination == Transfer.Destination.FILE ? new FileOutputStream(this.getFileName(), true) : new ByteArrayOutputStream((int)this.totalSize);
    }

    private int write(ByteBuffer bb) throws ClassNotFoundException, IOException {
        long bytes = Math.min(this.remainingSize, (long)bb.remaining());
        this.streamOut.write(bb.array(), bb.position(), (int)bytes);
        this.remainingSize -= bytes;
        bb.position((int)((long)bb.position() + bytes));
        if (this.remainingSize == 0L) {
            this.closeStream();
        }
        return (int)bytes;
    }

    private void closeStream() throws ClassNotFoundException, IOException {
        if (this.destination != Transfer.Destination.FILE) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.streamOut;
            this.array = baos.toByteArray();
            if (this.destination == Transfer.Destination.OBJECT) {
                this.object = Serializer.deserialize(this.array);
            }
        }
        try {
            this.streamOut.close();
        }
        catch (IOException e) {
            LOGGER.error("Error closing output stream on connection " + this);
        }
    }

    @Override
    public Transfer.Direction getDirection() {
        return Transfer.Direction.RECEIVE;
    }

    public void setReceptionDefaultFileName(String fname) {
        this.fileName = fname;
    }

    @Override
    public void start(LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) {
        --tokens;
    }

    @Override
    public long progress(LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) {
        if (!received.isEmpty()) {
            try {
                boolean initialized;
                if (!this.isInitialized() && !(initialized = this.initTransfer(received))) {
                    return Integer.MAX_VALUE;
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Can not read file for transfer on connection " + this, e);
                return Integer.MAX_VALUE;
            }
            ByteBuffer bb = null;
            int written = 0;
            while (!received.isEmpty() && !this.isComplete()) {
                bb = received.removeFirst();
                if (bb != null) {
                    try {
                        written = this.write(bb);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug(this + " has read " + written + " bytes, there are " + this.remainingSize + " out of " + this.totalSize + " missing. The packet still contains " + bb.remaining() + " bytes to be read.");
                    }
                    catch (IOException | ClassNotFoundException e) {
                        LOGGER.error("Can not write received values into the output for connection " + this);
                        written = 0;
                    }
                    continue;
                }
                written = 0;
            }
            if (written != 0) {
                received.addFirst(bb);
            }
            return this.remainingSize;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void notifyCompletion(Connection c, EventManager<?> em) {
        if (this.isData()) {
            em.dataReceived(c, this);
        } else if (this.isCommand()) {
            em.commandReceived(c, this);
        }
        ++tokens;
        if (pausedConnections.size() > 0) {
            InternalConnection ic = pausedConnections.removeFirst();
            ic.resume();
        }
    }

    @Override
    public void notifyError(Connection c, EventManager<?> em, CommException exc) {
        em.notifyError(c, this, exc);
        ++tokens;
        if (pausedConnections.size() > 0) {
            InternalConnection ic = pausedConnections.removeFirst();
            ic.resume();
        }
    }

    @Override
    public boolean checkViability(boolean closedCommunication, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) throws NIOException {
        if (!closedCommunication || !received.isEmpty()) {
            return tokens > 0;
        }
        throw new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, (Throwable)new Exception("Channel was already closed for connection " + this));
    }

    @Override
    public void pause(InternalConnection ic) {
        pausedConnections.add(ic);
    }
}

