/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.transfers.Transfer;
import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.NIOURI;
import integratedtoolkit.nio.commands.CommandDataDemand;
import integratedtoolkit.nio.commands.CommandDataNegate;
import integratedtoolkit.nio.commands.Data;
import integratedtoolkit.nio.commands.tracing.CommandGenerateDone;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.util.Serializer;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class NIOAgent {
    public static final String ID = NIOAgent.class.getCanonicalName();
    private int sendTransfers = 0;
    private final int MAX_SEND_TRANSFERS;
    private final Connection[] trasmittingConnections;
    private int receiveTransfers;
    private final int MAX_RECEIVE_TRANSFERS;
    private boolean finish;
    private Connection closingConnection = null;
    private final HashMap<String, LinkedList<DataRequest>> dataToRequests;
    private final LinkedList<DataRequest> pendingRequests;
    private final HashMap<Connection, String> ongoingTransfers;
    protected String masterIP;
    protected static int masterPort;
    protected NIONode masterNode;
    public static final Logger logger;
    public static final boolean debug;
    protected static boolean tracing;

    public NIOAgent(int snd, int rcv, int port) {
        this.MAX_SEND_TRANSFERS = snd;
        this.trasmittingConnections = new Connection[this.MAX_SEND_TRANSFERS];
        this.receiveTransfers = 0;
        this.MAX_RECEIVE_TRANSFERS = rcv;
        masterPort = port;
        this.ongoingTransfers = new HashMap();
        this.pendingRequests = new LinkedList();
        this.dataToRequests = new HashMap();
        this.finish = false;
    }

    public abstract void receivedNewTask(NIONode var1, NIOTask var2, LinkedList<String> var3);

    public abstract void setMaster(NIONode var1);

    public abstract boolean isMyUuid(String var1);

    public abstract void setWorkerIsReady(String var1);

    public void sendData(Connection c, Data d) {
        String path = d.getFirstURI().getPath();
        if (path.startsWith("/")) {
            File f = new File(path);
            if (f.exists()) {
                logger.debug("Connection " + c.hashCode() + " will transfer file " + path + " as data " + d.getName());
                c.sendDataFile(path);
            } else {
                logger.fatal("ERROR!!!!!!: Can't send file " + path + " via connection " + c.hashCode() + " because file doesn't exist.");
            }
        } else {
            Object o = this.getObject(path);
            logger.debug("Connection " + c.hashCode() + " will transfer an object  as data " + d.getName());
            c.sendDataObject(o);
        }
        c.finishConnection();
    }

    public void sendDataNegate(Connection c, Data d, boolean hosted) {
        CommandDataNegate cmd = new CommandDataNegate(this, d, hosted);
        c.sendCommand(cmd);
        c.finishConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAcquireReceiveSlot() {
        boolean b = false;
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            if (this.receiveTransfers < this.MAX_RECEIVE_TRANSFERS) {
                ++this.receiveTransfers;
                b = true;
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReceiveSlot() {
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            --this.receiveTransfers;
        }
    }

    public boolean tryAcquireSendSlot(Connection c) {
        boolean b = false;
        if (this.sendTransfers < this.MAX_SEND_TRANSFERS) {
            ++this.sendTransfers;
            b = true;
            for (int i = 0; i < this.MAX_SEND_TRANSFERS; ++i) {
                if (this.trasmittingConnections[i] != null) continue;
                this.trasmittingConnections[i] = c;
                break;
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSendSlot(Connection c) {
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            for (int i = 0; i < this.MAX_SEND_TRANSFERS; ++i) {
                if (this.trasmittingConnections[i] != c) continue;
                this.trasmittingConnections[i] = null;
                --this.sendTransfers;
                if (!this.finish || this.hasPendingTransfers()) break;
                this.shutdown(this.closingConnection);
                break;
            }
        }
    }

    public void receivedDataNegate(Connection c, boolean b) {
    }

    public NIONode getMaster() {
        return this.masterNode;
    }

    public abstract Object getObject(String var1);

    public abstract String getWorkingDir();

    public void receivedShutdown(Connection requester, LinkedList<Data> filesToSend) {
        this.closingConnection = requester;
        this.finish = true;
        if (!this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        }
    }

    public abstract void receivedTaskDone(Connection var1, int var2, boolean var3);

    public abstract void copiedData(int var1);

    public abstract void shutdownNotification(Connection var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferRequest(DataRequest dr) {
        LinkedList<DataRequest> list = this.dataToRequests.get(dr.source.getName());
        if (list == null) {
            list = new LinkedList();
            this.dataToRequests.put(dr.source.getName(), list);
            LinkedList<DataRequest> linkedList = this.pendingRequests;
            synchronized (linkedList) {
                this.pendingRequests.add(dr);
            }
        }
        list.add(dr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTransfers() {
        DataRequest dr = null;
        LinkedList<DataRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            if (!this.pendingRequests.isEmpty() && this.tryAcquireReceiveSlot()) {
                dr = this.pendingRequests.remove();
            }
        }
        while (dr != null) {
            Data source = dr.source;
            NIOURI uri = source.getFirstURI();
            NIONode nn = uri.getHost();
            if (nn.ip == null) {
                nn = this.masterNode;
            }
            Connection c = null;
            try {
                c = TransferManager.startConnection(nn);
                logger.debug("Connection " + c.hashCode() + " will be used to acquire data " + dr.getTarget + " stored in " + nn + " with name " + dr.source.getName());
                Data remoteData = new Data(source.getName(), uri);
                CommandDataDemand cdd = new CommandDataDemand(this, remoteData);
                this.ongoingTransfers.put(c, dr.source.getName());
                c.sendCommand(cdd);
                if (dr.type == ITExecution.ParamType.FILE_T) {
                    c.receiveDataFile(dr.getTarget);
                } else {
                    c.receiveDataObject();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (c != null) {
                    c.finishConnection();
                }
            }
            LinkedList<DataRequest> linkedList2 = this.pendingRequests;
            synchronized (linkedList2) {
                dr = !this.pendingRequests.isEmpty() && this.tryAcquireReceiveSlot() ? this.pendingRequests.remove() : null;
            }
        }
    }

    public void receivedData(Connection c, Transfer t) {
        String dataId = this.ongoingTransfers.remove(c);
        if (dataId == null) {
            return;
        }
        this.releaseReceiveSlot();
        LinkedList<DataRequest> requests = this.dataToRequests.remove(dataId);
        HashMap<String, LinkedList<DataRequest>> byTarget = new HashMap<String, LinkedList<DataRequest>>();
        for (DataRequest dataRequest : requests) {
            LinkedList<DataRequest> sameTarget = (LinkedList<DataRequest>)byTarget.get(dataRequest.getTarget());
            if (sameTarget == null) {
                sameTarget = new LinkedList<DataRequest>();
                byTarget.put(dataRequest.getTarget(), sameTarget);
            }
            sameTarget.add(dataRequest);
        }
        if (byTarget.size() == 1) {
            String targetName = requests.getFirst().getTarget();
            this.receivedValue(t.getDestination(), targetName, t.getObject(), requests);
        } else {
            if (t.isFile()) {
                this.receivedValue(t.getDestination(), t.getFileName(), t.getObject(), (LinkedList)byTarget.remove(t.getFileName()));
            } else {
                this.receivedValue(t.getDestination(), dataId, t.getObject(), (LinkedList)byTarget.remove(dataId));
            }
            for (Map.Entry entry : byTarget.entrySet()) {
                String targetName = (String)entry.getKey();
                LinkedList reqs = (LinkedList)entry.getValue();
                try {
                    if (t.isFile()) {
                        Files.copy(new File(t.getFileName()).toPath(), new File(targetName).toPath(), new CopyOption[0]);
                        this.receivedValue(t.getDestination(), targetName, t.getObject(), (LinkedList)byTarget.remove(targetName));
                        continue;
                    }
                    Object o = Serializer.deserialize(t.getArray());
                    this.receivedValue(t.getDestination(), targetName, o, reqs);
                }
                catch (Exception e) {
                    System.err.println("Can not replicate received Data");
                    e.printStackTrace(System.err);
                }
            }
        }
        this.requestTransfers();
        if (this.finish && !this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        }
    }

    public abstract void receivedValue(Transfer.Destination var1, String var2, Object var3, LinkedList<DataRequest> var4);

    public abstract void shutdown(Connection var1);

    public boolean hasPendingTransfers() {
        return !this.pendingRequests.isEmpty() || this.sendTransfers != 0 || this.receiveTransfers != 0;
    }

    public void generatePackage(Connection c, String host, String installDir, String workingDir, String name) {
        NIOTracer.generatePackage();
        c.sendCommand(new CommandGenerateDone());
        c.finishConnection();
    }

    public abstract void waitUntilTracingPackageGenerated();

    public abstract void notifyTracingPackageGeneration();

    static {
        logger = Logger.getLogger("integratedtoolkit.Communication");
        debug = logger.isDebugEnabled();
    }

    public static abstract class DataRequest {
        private final Data source;
        private final ITExecution.ParamType type;
        private final String getTarget;

        public DataRequest(ITExecution.ParamType type, Data source, String target) {
            this.source = source;
            this.getTarget = target;
            this.type = type;
        }

        public Data getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.getTarget;
        }

        public ITExecution.ParamType getType() {
            return this.type;
        }

        public static class MasterDataRequest
        extends DataRequest {
            final DataOperation fOp;

            public MasterDataRequest(DataOperation fOp, ITExecution.ParamType type, Data source, String target) {
                super(type, source, target);
                this.fOp = fOp;
            }

            public DataOperation getOperation() {
                return this.fOp;
            }
        }
    }
}

