/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import integratedtoolkit.nio.commands.Command;
import integratedtoolkit.nio.commands.CommandCheckWorkerACK;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandCheckWorker
extends Command
implements Externalizable {
    private String uuid;
    private String nodeName;

    public CommandCheckWorker() {
    }

    public CommandCheckWorker(String uuid, String nodeName) {
        this.uuid = uuid;
        this.nodeName = nodeName;
    }

    @Override
    public Command.CommandType getType() {
        return Command.CommandType.CHECK_WORKER;
    }

    @Override
    public void handle(Connection c) {
        if (this.agent.isMyUuid(this.uuid)) {
            this.agent.setMaster((NIONode)c.getNode());
            CommandCheckWorkerACK cmd = new CommandCheckWorkerACK(this.uuid, this.nodeName);
            c.sendCommand(cmd);
        }
        c.finishConnection();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uuid = in.readUTF();
        this.nodeName = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.uuid);
        out.writeUTF(this.nodeName);
    }

    public String toString() {
        return "CommandCheckWorker for deployment ID " + this.uuid + " on nodeName " + this.nodeName;
    }
}

