/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.master;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.transfers.Transfer;
import integratedtoolkit.api.ITExecution;
import integratedtoolkit.comm.Comm;
import integratedtoolkit.comm.CommAdaptor;
import integratedtoolkit.nio.NIOAgent;
import integratedtoolkit.nio.NIOMessageHandler;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.NIOURI;
import integratedtoolkit.nio.commands.CommandNewTask;
import integratedtoolkit.nio.commands.Data;
import integratedtoolkit.nio.master.NIOJob;
import integratedtoolkit.nio.master.NIOWorkerNode;
import integratedtoolkit.nio.master.WorkerStarter;
import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.data.operation.Copy;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ShutdownListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class NIOAdaptor
extends NIOAgent
implements CommAdaptor {
    public static final int MAX_SEND = 1000;
    public static final int MAX_RECEIVE = 1000;
    public static final int MAX_SEND_WORKER = 5;
    public static final int MAX_RECEIVE_WORKER = 5;
    public static final int MASTER_PORT = 43000;
    private static final String JOBS_DIR = System.getProperty("it.appLogDir") + "jobs" + File.separator;
    private static final String TERM_ERR = "Error terminating";
    private static final HashSet<NIOWorkerNode> nodes = new HashSet();
    private static final ConcurrentHashMap<Integer, NIOJob> runningJobs = new ConcurrentHashMap();
    private static final HashMap<Integer, LinkedList<Copy>> groupToCopy = new HashMap();
    private static final HashMap<Connection, ClosingWorker> stoppingNodes = new HashMap();
    private Semaphore tracingGeneration = new Semaphore(0);
    public static boolean workerDebug = Logger.getLogger("integratedtoolkit.Worker").isDebugEnabled();

    public NIOAdaptor() {
        super(1000, 1000, 43000);
        File file = new File(JOBS_DIR);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    @Override
    public void init() {
        logger.debug("INIT NIO Adaptor");
        this.masterNode = new NIONode(null, 43000);
        final NIOMessageHandler mhm = new NIOMessageHandler(this, this.masterNode);
        new Thread(){

            @Override
            public void run() {
                TransferManager.init("NIO", null, mhm);
            }
        }.start();
    }

    @Override
    public NIOWorkerNode initWorker(String name, HashMap<String, String> properties, TreeMap<String, AdaptorDescription> adaptorsDesc) throws Exception {
        logger.debug("Init NIO Worker Node");
        NIOWorkerNode worker = null;
        worker = new NIOWorkerNode(name, properties, this);
        NIONode n = new WorkerStarter(worker, adaptorsDesc).startWorker();
        worker.setNode(n);
        nodes.add(worker);
        return worker;
    }

    public void removedNode(NIOWorkerNode worker) {
        logger.debug("Remove worker " + worker.getName());
        nodes.remove(worker);
    }

    @Override
    public void stop() {
        logger.debug("NIO Adaptor stoping workers...");
        HashSet<NIOWorkerNode> workers = new HashSet<NIOWorkerNode>();
        workers.addAll(nodes);
        Semaphore sem = new Semaphore(0);
        ShutdownListener sl = new ShutdownListener(sem);
        for (NIOWorkerNode worker : workers) {
            logger.debug("- Stopping worker" + worker.getName());
            worker.stop(sl);
        }
        logger.debug("- Waiting for workers to shutdown...");
        sl.enable();
        try {
            sem.acquire();
        }
        catch (Exception e) {
            logger.error("ERROR: Exception raised on worker shutdown");
        }
        logger.debug("- Workers stoped");
        logger.debug("- Shutting down TM...");
        TransferManager.shutdown(null);
        logger.debug("NIO Adaptor stop completed!");
    }

    protected static void submitTask(NIOJob job) {
        logger.debug("NIO submitting new job " + job.getJobId());
        Resource res = job.getResource();
        NIOWorkerNode node = (NIOWorkerNode)res.getNode();
        NIONode hostNode = node.getNode();
        LinkedList<String> obsolete = res.clearObsoletes();
        runningJobs.put(job.getJobId(), job);
        NIOTask t = job.prepareJob();
        Connection c = TransferManager.startConnection(hostNode);
        CommandNewTask cmd = new CommandNewTask(t, obsolete);
        c.sendCommand(cmd);
        c.finishConnection();
    }

    @Override
    public void receivedNewTask(NIONode master, NIOTask t, LinkedList<String> obsoleteFiles) {
    }

    @Override
    public void setMaster(NIONode master) {
    }

    @Override
    public boolean isMyUuid(String uuid) {
        return false;
    }

    @Override
    public void setWorkerIsReady(String nodeName) {
        logger.info("Notifying that worker is ready " + nodeName);
        WorkerStarter ws = WorkerStarter.getWorkerStarter(nodeName);
        ws.setWorkerIsReady();
    }

    @Override
    public void receivedTaskDone(Connection c, int jobId, boolean successful) {
        NIOJob nj = runningJobs.remove(jobId);
        Job.JobHistory h = nj.getHistory();
        nj.taskFinished(successful);
        if (workerDebug) {
            c.receiveDataFile(JOBS_DIR + "job" + nj.getJobId() + "_" + (Object)((Object)h) + ".out");
            c.receiveDataFile(JOBS_DIR + "job" + nj.getJobId() + "_" + (Object)((Object)h) + ".err");
        } else if (!successful) {
            c.receiveDataFile(JOBS_DIR + "job" + nj.getJobId() + "_" + (Object)((Object)nj.getHistory()) + ".err");
        }
        c.finishConnection();
    }

    public void registerCopy(Copy c) {
        for (DataOperation.EventListener el : c.getEventListeners()) {
            Integer groupId = el.getId();
            LinkedList<Copy> copies = groupToCopy.get(groupId);
            if (copies == null) {
                copies = new LinkedList();
                groupToCopy.put(groupId, copies);
            }
            copies.add(c);
        }
    }

    @Override
    public void receivedValue(Transfer.Destination type, String dataId, Object object, LinkedList<NIOAgent.DataRequest> achievedRequests) {
        for (NIOAgent.DataRequest dr : achievedRequests) {
            NIOAgent.DataRequest.MasterDataRequest mdr = (NIOAgent.DataRequest.MasterDataRequest)dr;
            Copy c = (Copy)mdr.getOperation();
            DataLocation actualLocation = c.getSourceData().finishedCopy(c);
            LogicalData tgtData = c.getTargetData();
            if (tgtData != null) {
                tgtData.addLocation(actualLocation);
                if (object != null) {
                    tgtData.setValue(object);
                }
            }
            c.end(DataOperation.OpEndState.OP_OK);
        }
    }

    @Override
    public void copiedData(int transferGroupId) {
        LinkedList<Copy> copies = groupToCopy.remove(transferGroupId);
        if (copies == null) {
            return;
        }
        for (Copy c : copies) {
            if (!c.isRegistered()) continue;
            DataLocation actualLocation = c.getSourceData().finishedCopy(c);
            LogicalData tgtData = c.getTargetData();
            if (tgtData == null) continue;
            tgtData.addLocation(actualLocation);
        }
    }

    @Override
    public LinkedList<DataOperation> getPending() {
        return new LinkedList<DataOperation>();
    }

    public boolean checkData(Data d) {
        boolean data = false;
        return data;
    }

    @Override
    public Object getObject(String name) {
        return Comm.getData(name).getValue();
    }

    @Override
    public String getWorkingDir() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSubmittedJobs() {
        ConcurrentHashMap<Integer, NIOJob> concurrentHashMap = runningJobs;
        synchronized (concurrentHashMap) {
            for (Job job : runningJobs.values()) {
                try {
                    job.stop();
                }
                catch (Exception e) {
                    logger.error(TERM_ERR, e);
                }
            }
        }
    }

    @Override
    public void completeMasterURI(URI u) {
        u.setInternalURI(ID, new NIOURI(this.masterNode, u.getPath()));
    }

    public void requestData(Copy c, ITExecution.ParamType paramType, Data d, String path) {
        NIOAgent.DataRequest.MasterDataRequest dr = new NIOAgent.DataRequest.MasterDataRequest(c, paramType, d, path);
        this.addTransferRequest(dr);
        this.requestTransfers();
    }

    public void shuttingDown(NIOWorkerNode worker, Connection c, ShutdownListener listener) {
        stoppingNodes.put(c, new ClosingWorker(worker, listener));
    }

    @Override
    public void shutdownNotification(Connection c) {
        ClosingWorker closing = stoppingNodes.remove(c);
        NIOWorkerNode worker = closing.worker;
        this.removedNode(worker);
        ShutdownListener listener = closing.listener;
        listener.notifyEnd();
    }

    @Override
    public void shutdown(Connection closingConnection) {
    }

    @Override
    public void waitUntilTracingPackageGenerated() {
        try {
            this.tracingGeneration.acquire();
        }
        catch (InterruptedException ex) {
            logger.error("Error waiting for package generation");
        }
    }

    @Override
    public void notifyTracingPackageGeneration() {
        this.tracingGeneration.release();
    }

    private class ClosingWorker {
        private final NIOWorkerNode worker;
        private final ShutdownListener listener;

        public ClosingWorker(NIOWorkerNode w, ShutdownListener l) {
            this.worker = w;
            this.listener = l;
        }
    }
}

