/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.master;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.NIOParam;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.commands.Data;
import integratedtoolkit.nio.master.NIOAdaptor;
import integratedtoolkit.nio.master.NIOWorkerNode;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.MethodImplementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.parameter.BasicTypeParameter;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.Resource;
import java.util.LinkedList;

public class NIOJob
extends Job<NIOWorkerNode> {
    private static final String workerClasspath = System.getProperty("it.worker.cp") != null && System.getProperty("it.worker.cp").compareTo("") != 0 ? System.getProperty("it.worker.cp") : "\"\"";

    public NIOJob(Task task, Implementation<?> impl, Resource res, Job.JobListener listener) {
        super(task, impl, res, listener);
    }

    @Override
    public String getHostName() {
        return this.worker.getName();
    }

    @Override
    public String toString() {
        MethodImplementation method = (MethodImplementation)this.impl;
        TaskParams taskParams = this.task.getTaskParams();
        String className = method.getDeclaringClass();
        String methodName = taskParams.getName();
        return "NIOJob JobId" + this.jobId + " for method " + methodName + " at class " + className;
    }

    @Override
    public void submit() throws Exception {
        logger.info("Submit NIOJob with ID " + this.jobId);
        NIOAdaptor.submitTask(this);
    }

    public NIOTask prepareJob() {
        MethodImplementation method = (MethodImplementation)this.impl;
        TaskParams taskParams = this.task.getTaskParams();
        String className = method.getDeclaringClass();
        String methodName = taskParams.getName();
        boolean hasTarget = taskParams.hasTargetObject();
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size();
        if (taskParams.hasReturnValue()) {
            --numParams;
        }
        NIOTask nt = new NIOTask(lang, ((NIOWorkerNode)this.getResourceNode()).getInstallDir(), ((NIOWorkerNode)this.getResourceNode()).getLibPath(), ((NIOWorkerNode)this.getResourceNode()).getAppDir(), workerClasspath, workerDebug, className, methodName, hasTarget, params, numParams, this.task.getTaskParams().getId(), this.task.getId(), this.jobId, this.history, this.transferId);
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        TaskParams taskParams = this.task.getTaskParams();
        for (Parameter param : taskParams.getParameters()) {
            NIOParam np;
            Object value;
            ITExecution.ParamType type = param.getType();
            if (type == ITExecution.ParamType.FILE_T || type == ITExecution.ParamType.OBJECT_T) {
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                value = dPar.getDataTarget();
                boolean serialize = type == ITExecution.ParamType.OBJECT_T && !(dAccId instanceof DataAccessId.RWAccessId);
                np = new NIOParam(type, value, serialize, (Data)dPar.getDataSource());
            } else {
                BasicTypeParameter btParB = (BasicTypeParameter)param;
                value = btParB.getValue();
                np = new NIOParam(type, value, false, null);
            }
            params.add(np);
        }
        return params;
    }

    @Override
    public Job.JobKind getKind() {
        return Job.JobKind.METHOD;
    }

    public void taskFinished(boolean successful) {
        if (successful) {
            this.listener.jobCompleted(this);
        } else {
            this.listener.jobFailed(this, Job.JobListener.JobEndStatus.EXECUTION_FAILED);
        }
    }

    @Override
    public void stop() throws Exception {
    }
}

