/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.commandlineSsh;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.SerializedJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandlineSshJob
extends JobCpi {
    protected static Logger logger = LoggerFactory.getLogger(CommandlineSshJob.class);
    JobDescription description;
    Process p;
    private String processID = null;
    int exitStatus = 0;
    MetricDefinition statusMetricDefinition;
    Metric statusMetric;
    private StreamForwarder outputStreamFile;
    private StreamForwarder errorStreamFile;

    CommandlineSshJob(GATContext gatContext, JobDescription description, Sandbox sandbox) {
        super(gatContext, description, sandbox);
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "JobState", null, null, returnDef);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
    }

    CommandlineSshJob(GATContext gatContext, SerializedJob sj) {
        super(gatContext, sj.getJobDescription(), sj.getSandbox());
        this.processID = sj.getJobId().toString();
        this.starttime = sj.getStarttime();
        this.stoptime = sj.getStoptime();
        this.submissiontime = sj.getSubmissiontime();
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "JobState", null, null, returnDef);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProcess(Process p) {
        this.p = p;
        Field f = null;
        try {
            f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            this.processID = f.get(p).toString();
            CommandlineSshJob commandlineSshJob = this;
            synchronized (commandlineSshJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(Job.JobState state) {
        CommandlineSshJob commandlineSshJob = this;
        synchronized (commandlineSshJob) {
            this.state = state;
        }
        MetricEvent v = new MetricEvent((Object)this, (Object)state, this.statusMetric, System.currentTimeMillis());
        this.fireMetric(v);
    }

    public synchronized Map<String, Object> getInfo() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("state", this.state.toString());
        if (this.state != Job.JobState.RUNNING) {
            m.put("hostname", null);
        } else {
            m.put("hostname", "not available");
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN) {
            m.put("submissiontime", null);
        } else {
            if (this.processID != null) {
                m.put("adaptor.job.id", this.processID);
            }
            m.put("submissiontime", this.submissiontime);
        }
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN || this.state == Job.JobState.SCHEDULED) {
            m.put("starttime", null);
        } else {
            m.put("starttime", this.starttime);
        }
        if (this.state != Job.JobState.STOPPED) {
            m.put("stoptime", null);
        } else {
            m.put("stoptime", this.stoptime);
        }
        m.put("poststage.exception", (Object)this.postStageException);
        m.put("resourcebroker", "CommandlineSsh");
        try {
            m.put("exitvalue", "" + this.getExitStatus());
        }
        catch (GATInvocationException gATInvocationException) {
            // empty catch block
        }
        if (this.deleteException != null) {
            m.put("delete.exception", (Object)this.deleteException);
        }
        if (this.wipeException != null) {
            m.put("wipe.exception", (Object)this.wipeException);
        }
        return m;
    }

    public synchronized int getExitStatus() throws GATInvocationException {
        if (this.state != Job.JobState.STOPPED) {
            throw new GATInvocationException("not in STOPPED state");
        }
        return this.exitStatus;
    }

    public synchronized void stop() throws GATInvocationException {
        this.stop(this.gatContext.getPreferences().containsKey("job.stop.poststage") && this.gatContext.getPreferences().get("job.stop.poststage").equals("false"), true);
    }

    void setErrorStream(StreamForwarder err) {
        this.errorStreamFile = err;
    }

    void setOutputStream(StreamForwarder out) {
        this.outputStreamFile = out;
    }

    private synchronized void stop(boolean skipPostStage, boolean kill) throws GATInvocationException {
        if (this.state == Job.JobState.POST_STAGING || this.state == Job.JobState.STOPPED || this.state == Job.JobState.SUBMISSION_ERROR) {
            return;
        }
        if (this.p != null && kill) {
            this.p.destroy();
        }
        if (this.outputStreamFile != null) {
            this.outputStreamFile.waitUntilFinished();
            try {
                this.outputStreamFile.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.errorStreamFile != null) {
            this.errorStreamFile.waitUntilFinished();
            try {
                this.errorStreamFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!skipPostStage) {
            this.setState(Job.JobState.POST_STAGING);
            this.sandbox.retrieveAndCleanup((JobCpi)this);
        }
        if (this.exitStatus == 255) {
            this.setState(Job.JobState.SUBMISSION_ERROR);
        } else {
            this.setState(Job.JobState.STOPPED);
        }
        this.finished();
    }

    public OutputStream getStdin() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStdinEnabled()) {
            return this.p.getOutputStream();
        }
        throw new GATInvocationException("stdin streaming is not enabled!");
    }

    public InputStream getStdout() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStdoutEnabled()) {
            return this.p.getInputStream();
        }
        throw new GATInvocationException("stdout streaming is not enabled!");
    }

    public InputStream getStderr() throws GATInvocationException {
        if (this.jobDescription.getSoftwareDescription().streamingStderrEnabled()) {
            return this.p.getErrorStream();
        }
        throw new GATInvocationException("stderr streaming is not enabled!");
    }

    protected void monitorState() {
        new StateMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String marshal() {
        SerializedJob sj;
        CommandlineSshJob commandlineSshJob = this;
        synchronized (commandlineSshJob) {
            while (this.processID == null) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (Exception exception) {}
            }
            sj = new SerializedJob(((Object)((Object)this)).getClass().getName(), this.jobDescription, this.sandbox, this.processID, this.submissiontime, this.starttime, this.stoptime);
        }
        String res = GATEngine.defaultMarshal((Object)sj);
        if (logger.isDebugEnabled()) {
            logger.debug("marshalled seralized job: " + res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Advertisable unmarshal(GATContext context, String s) throws GATObjectCreationException {
        if (logger.isDebugEnabled()) {
            logger.debug("serialized job to unmarshal: " + s);
        }
        SerializedJob sj = (SerializedJob)GATEngine.defaultUnmarshal(SerializedJob.class, (String)s, (String)CommandlineSshJob.class.getName());
        if (logger.isDebugEnabled()) {
            logger.debug("unmarshalled serialized job: " + sj);
        }
        Class<JobCpi> clazz = JobCpi.class;
        synchronized (JobCpi.class) {
            for (int i = 0; i < jobList.size(); ++i) {
                JobCpi j = (JobCpi)jobList.get(i);
                if (!(j instanceof CommandlineSshJob)) continue;
                CommandlineSshJob gj = (CommandlineSshJob)j;
                if (!sj.getJobId().equals(gj.processID)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return gj;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new CommandlineSshJob(context, sj);
        }
    }

    class StateMonitor
    extends Thread {
        StateMonitor() {
            this.setName("command line ssh state monitor: " + CommandlineSshJob.this.jobDescription.getSoftwareDescription().getExecutable());
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            block8: {
                block7: {
                    block6: {
                        try {
                            CommandlineSshJob.this.p.waitFor();
                        }
                        catch (InterruptedException e) {
                            if (!logger.isDebugEnabled()) break block6;
                            logger.debug("p.waitFor is interrupted (commandline ssh)");
                        }
                    }
                    try {
                        CommandlineSshJob.this.exitStatus = CommandlineSshJob.this.p.exitValue();
                    }
                    catch (NullPointerException e) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug("unable to retrieve exit status");
                    }
                }
                try {
                    CommandlineSshJob.this.stop(false, false);
                }
                catch (GATInvocationException e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("unable to stop job: " + (Object)((Object)e));
                }
            }
        }
    }
}

