/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sftpTrilead;

import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import java.io.IOException;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.RandomAccessFileCpi;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadConnection;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadFileAdaptor;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadHostVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpTrileadRandomAccessFileAdaptor
extends RandomAccessFileCpi {
    protected static Logger logger = LoggerFactory.getLogger(SftpTrileadRandomAccessFileAdaptor.class);
    private final SftpTrileadConnection connection;
    private final SFTPv3FileHandle handle;
    private long currentPos;
    private long size;
    private boolean closed;
    private final boolean readOnly;

    public static String getDescription() {
        return "The SftpTrilead RandomAccessFile Adaptor implements the RandomAccessFile object using the SFTP support of the trilead ssh library. Trilead ssh is an open source full java ssh library. On the server side, the 'scp' program must be in the PATH. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = RandomAccessFileCpi.getSupportedPreferences();
        preferences.put("sftptrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sftptrilead.noHostKeyChecking", (Object)"true");
        preferences.put("sftptrilead.cipher.client2server", (Object)"<sftp default>");
        preferences.put("sftptrilead.cipher.server2client", (Object)"<sftp default>");
        preferences.put("sftptrilead.tcp.nodelay", (Object)"true");
        preferences.put("sftptrilead.connect.timeout", (Object)"5000");
        preferences.put("sftptrilead.kex.timeout", (Object)"5000");
        return preferences;
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = RandomAccessFileCpi.getSupportedCapabilities();
        capabilities.put("close", true);
        capabilities.put("getFilePointer", true);
        capabilities.put("length", true);
        capabilities.put("read", true);
        capabilities.put("seek", true);
        capabilities.put("skipBytes", true);
        capabilities.put("write", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"sftptrilead", "sftp", "file"};
    }

    public SftpTrileadRandomAccessFileAdaptor(GATContext gatContext, URI location, String mode) throws GATObjectCreationException {
        block13: {
            super(gatContext, location, mode);
            this.closed = false;
            if (location.isCompatible("file") && location.refersToLocalHost()) {
                throw new GATObjectCreationException("this adaptor cannot deal with local files");
            }
            Preferences p = gatContext.getPreferences();
            boolean noHostKeyChecking = ((String)p.get("sftptrilead.noHostKeyChecking", (Object)"true")).equalsIgnoreCase("true");
            boolean strictHostKeyChecking = ((String)p.get("sftptrilead.strictHostKeyChecking", (Object)"false")).equalsIgnoreCase("true");
            String client2serverCipherString = (String)p.get("sftptrilead.cipher.client2server");
            String[] client2serverCiphers = client2serverCipherString == null ? null : client2serverCipherString.split(",");
            String server2clientCipherString = (String)p.get("sftptrilead.cipher.server2client");
            String[] server2clientCiphers = server2clientCipherString == null ? null : server2clientCipherString.split(",");
            boolean tcpNoDelay = ((String)p.get("sftptrilead.tcp.nodelay", (Object)"true")).equalsIgnoreCase("true");
            SftpTrileadHostVerifier verifier = new SftpTrileadHostVerifier(false, strictHostKeyChecking, noHostKeyChecking);
            try {
                this.connection = SftpTrileadFileAdaptor.getConnection(gatContext, location, verifier, client2serverCiphers, server2clientCiphers, tcpNoDelay);
            }
            catch (GATInvocationException e) {
                logger.debug("Could not create connection", (Throwable)e);
                throw new GATObjectCreationException("Could not create connection", (Throwable)e);
            }
            try {
                SFTPv3FileAttributes attributes = null;
                try {
                    attributes = this.connection.sftpClient.stat(location.getPath());
                }
                catch (Throwable e) {
                    logger.debug("Could not get file attributes", e);
                }
                if ("r".equals(mode)) {
                    this.handle = this.connection.sftpClient.openFileRO(location.getPath());
                    this.size = attributes.size;
                    this.readOnly = true;
                    break block13;
                }
                if ("rw".equals(mode) || "rws".equals(mode) || "rwd".equals(mode)) {
                    if (attributes == null) {
                        this.handle = this.connection.sftpClient.createFile(location.getPath());
                        this.size = 0L;
                    } else {
                        this.size = attributes.size;
                        this.handle = this.connection.sftpClient.openFileRW(location.getPath());
                    }
                    this.readOnly = false;
                    break block13;
                }
                throw new GATObjectCreationException("Illegal mode: " + mode);
            }
            catch (IOException e) {
                logger.debug("Could not open file", (Throwable)e);
                try {
                    SftpTrileadFileAdaptor.closeConnection(this.connection, gatContext.getPreferences());
                }
                catch (Throwable e1) {
                    // empty catch block
                }
                throw new GATObjectCreationException("Could not open file", (Throwable)e);
            }
        }
        this.currentPos = 0L;
    }

    public void close() throws GATInvocationException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.connection.sftpClient.closeFile(this.handle);
            }
            catch (Throwable e1) {
                logger.debug("sftpClient.closeFile: ", e1);
            }
            try {
                SftpTrileadFileAdaptor.closeConnection(this.connection, this.gatContext.getPreferences());
            }
            catch (Throwable e) {
                logger.debug("SftpTrileadFileAdaptor.closeConnection: ", e);
            }
        }
    }

    public long getFilePointer() {
        return this.currentPos;
    }

    public long length() throws GATInvocationException {
        return this.size;
    }

    public void seek(long arg0) throws GATInvocationException {
        if (this.closed) {
            throw new GATInvocationException("seek: file is closed");
        }
        if (arg0 < 0L) {
            throw new GATInvocationException("seek: arg < 0");
        }
        this.currentPos = arg0;
    }

    public int read(byte[] buf, int off, int len) throws GATInvocationException {
        if (this.closed) {
            throw new GATInvocationException("read: file is closed");
        }
        if (len == 0) {
            return 0;
        }
        if (len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException("read: illegal parameters");
        }
        try {
            int total = 0;
            while (len != 0) {
                int sz = Math.min(len, 32768);
                int length = this.connection.sftpClient.read(this.handle, this.currentPos, buf, off, sz);
                if (length < 0) {
                    if (total == 0) {
                        return -1;
                    }
                    return total;
                }
                len -= length;
                off += length;
                this.currentPos += (long)length;
                total += length;
            }
            return total;
        }
        catch (Throwable e) {
            throw new GATInvocationException("SftpTrileadRandomAccessFile", e);
        }
    }

    public int skipBytes(int len) throws GATInvocationException {
        if (this.closed) {
            throw new GATInvocationException("skipBytes: file is closed");
        }
        if (len <= 0) {
            return 0;
        }
        if (this.currentPos + (long)len > this.size) {
            if (this.currentPos >= this.size) {
                return 0;
            }
            len = (int)(this.size - this.currentPos);
            this.currentPos = this.size;
            return len;
        }
        this.currentPos += (long)len;
        return len;
    }

    public void write(byte[] buf, int off, int len) throws GATInvocationException {
        if (this.closed) {
            throw new GATInvocationException("write: file is closed");
        }
        if (this.readOnly) {
            throw new GATInvocationException("write: file is opened read-only");
        }
        if (len == 0) {
            return;
        }
        if (len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException("write: illegal parameters");
        }
        try {
            this.connection.sftpClient.write(this.handle, this.currentPos, buf, off, len);
            this.currentPos += (long)len;
            if (this.currentPos > this.size) {
                this.size = this.currentPos;
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("write gave exception", (Throwable)e);
        }
    }
}

