#!/bin/bash
#
# This file is automatically generated by the Extrae instrumentation Makefile.
# DO NOT EDIT!
#

if test "${EXTRAE_HOME}" != "" ; then
	if test -d ${EXTRAE_HOME} ; then
		echo "EXTRAE_HOME points to ${EXTRAE_HOME} and the directory exists .. OK"
	else
		echo "EXTRAE_HOME points to ${EXTRAE_HOME} and the directory does NOT exist .. FAILED"
	fi
else
	echo "EXTRAE_HOME is undefined... Cannot proceed much more!"
	echo "Please, define EXTRAE_HOME environment variable to a Extrae package installation"
fi

if test "${EXTRAE_HOME}" != "" ; then

	# Read configuration variables if available!
	if ! test -f ${EXTRAE_HOME}/etc/extrae-vars.sh ; then
		echo "Error! Unable to locate ${EXTRAE_HOME}/etc/extrae-vars.sh"
		echo "Dying..."
		exit 
	else
		source ${EXTRAE_HOME}/etc/extrae-vars.sh
		echo "Loaded specs for ${PACKAGE_NAME:-Extrae} from ${EXTRAE_HOME}/etc/extrae-vars.sh"
	fi

	echo
	echo Extrae SVN branch ${EXTRAE_SVN_BRANCH} at revision ${EXTRAE_SVN_REVISION}
	echo

	echo ${PACKAGE_NAME} was configured with:
	echo ${CONFIGURE_LINE}
	echo
	echo CC       was ${EXTRAE_CC} 
	echo CFLAGS   was ${EXTRAE_CFLAGS} 
	echo CXX      was ${EXTRAE_CXX}
	echo CXXFLAGS was ${EXTRAE_CXXFLAGS}
	echo

	if test "${EXTRAE_MPI_HOME}" != "" ; then
		if test -d ${EXTRAE_MPI_HOME} ; then
			echo "MPI_HOME points to ${EXTRAE_MPI_HOME} and the directory exists .. OK"
		else
			echo "MPI_HOME points to ${EXTRAE_MPI_HOME} and the directory does NOT exist .. FAILED"
		fi
	else
		echo "MPI support seems to be disabled"
	fi

	if test "${EXTRAE_PACX_HOME}" != "" ; then
		if test -d ${EXTRAE_PACX_HOME} ; then
			echo "PACX_HOME points to ${EXTRAE_PACX_HOME} and the directory exists .. OK"
		else
			echo "PACX_HOME points to ${EXTRAE_PACX_HOME} and the directory does NOT exist .. FAILED"
		fi
	else
		echo "PACX support seems to be disabled"
	fi

	if test "${EXTRAE_LIBXML2_HOME}" != "" ; then
		if test -d ${EXTRAE_LIBXML2_HOME} ; then
			echo "LIBXML2_HOME points to ${EXTRAE_LIBXML2_HOME} and the directory exists .. OK"
		else
			echo "LIBXML2_HOME points to ${EXTRAE_LIBXML2_HOME} and the directory does NOT exist .. FAILED"
		fi
	else
		echo "XML support seems to be disabled"
	fi

	if test "${EXTRAE_PAPI_HOME}" != "" ; then
		if test -d ${EXTRAE_PAPI_HOME} ; then
			echo "PAPI_HOME points to ${EXTRAE_PAPI_HOME} and the directory exists .. OK"
		else
			echo "PAPI_HOME points to ${EXTRAE_PAPI_HOME} and the directory does NOT exist .. FAILED"
		fi
	else
		echo "PAPI support seems to be disabled"
	fi

	if test "${EXTRAE_DYNINST_HOME}" != "" ; then
		if test -d ${EXTRAE_DYNINST_HOME} ; then
			echo "DYNINST_HOME points to ${EXTRAE_DYNINST_HOME} and the directory exists .. OK"
		else
			echo "DYNINST_HOME points to ${EXTRAE_DYNINST_HOME} and the directory does NOT exist .. FAILED"
		fi
		# Dwarf is required by dyninst
		if test -d ${EXTRAE_DWARF_HOME} ; then
			echo "DWARF_HOME points to ${EXTRAE_DWARF_HOME} and the directory exists .. OK"
		else
			echo "DWARF_HOME points to ${EXTRAE_DWARF_HOME} and the directory does NOT exist .. FAILED"
		fi
	else
		echo "DYNINST support seems to be disabled"
	fi

	if test "${EXTRAE_UNWIND_HOME}" != "" ; then
		if test -d ${EXTRAE_UNWIND_HOME} ; then
			echo "UNWIND_HOME points to ${EXTRAE_UNWIND_HOME} and the directory exists .. OK"
		else
			echo "UNWIND_HOME points to ${EXTRAE_UNWIND_HOME} and the directory does NOT exist .. FAILED"
		fi
	else
		echo "UNWINDing support seems to be disabled (or not needed)"
	fi

	if test "${EXTRAE_LIBERTY_HOME}" != "" -a "${EXTRAE_BFD_HOME}" != ""; then
		if test -d ${EXTRAE_LIBERTY_HOME} ; then
			echo "LIBERTY_HOME points to ${EXTRAE_LIBERTY_HOME} and the directory exists .. OK"
		else
			echo "LIBERTY_HOME points to ${EXTRAE_LIBERTY_HOME} and the directory does NOT exist .. FAILED"
		fi
		if test -d ${EXTRAE_BFD_HOME} ; then
			echo "BFD_HOME points to ${EXTRAE_BFD_HOME} and the directory exists .. OK"
		else
			echo "BFD_HOME points to ${EXTRAE_BFD_HOME} and the directory does NOT exist .. FAILED"
		fi
	else
		echo "Translating addresses into source code references seems to be disabled (or not needed)"
	fi
fi

echo 
echo "Please, report bugs to ${PACKAGE_BUGREPORT:-tools@bsc.es}"
echo

