/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.sshlsf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.SerializedSimpleJobBase;
import org.gridlab.gat.resources.cpi.SimpleJobBase;
import org.gridlab.gat.resources.cpi.sshlsf.SshLsfResourceBrokerAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshLSFJob
extends SimpleJobBase
implements MetricListener {
    protected static Logger logger = LoggerFactory.getLogger(SshLSFJob.class);
    private static final long serialVersionUID = 1L;
    private final ResourceBroker jobHelper;
    private final GATContext subContext;
    boolean jobStateBusy = false;
    private boolean sawJob = false;
    private int missedJob = 0;

    protected SshLSFJob(GATContext gatContext, URI brokerURI, JobDescription jobDescription, Sandbox sandbox, ResourceBroker jobHelper, String returnValueFile) {
        super(gatContext, brokerURI, jobDescription, sandbox, returnValueFile);
        this.jobHelper = jobHelper;
        this.subContext = SshLsfResourceBrokerAdaptor.getSubContext(gatContext);
    }

    public SshLSFJob(GATContext gatContext, SerializedSimpleJobBase sj) throws GATObjectCreationException {
        super(gatContext, sj);
        this.subContext = SshLsfResourceBrokerAdaptor.getSubContext(gatContext);
        try {
            this.jobHelper = SshLsfResourceBrokerAdaptor.subResourceBroker(this.subContext, this.brokerURI);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("Could not create broker to get Slurm job status", (Throwable)e);
        }
        this.startListener();
    }

    protected synchronized void setJobID(String jobID) {
        super.setJobID(jobID);
        ((Object)((Object)this)).notifyAll();
    }

    public static Advertisable unmarshal(GATContext context, String s) throws GATObjectCreationException {
        return SimpleJobBase.unmarshal((GATContext)context, (String)s, (ClassLoader)SshLSFJob.class.getClassLoader());
    }

    protected void setSoft(SoftwareDescription Soft) {
        super.setSoft(Soft);
    }

    protected void setState(Job.JobState state) {
        super.setState(state);
    }

    protected void startListener() {
        super.startListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getJobState(String jobID) throws GATInvocationException {
        Job.JobState resultState;
        SshLSFJob sshLSFJob = this;
        synchronized (sshLSFJob) {
            while (this.jobStateBusy) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {}
            }
            this.jobStateBusy = true;
        }
        try {
            if (this.state == Job.JobState.POST_STAGING || this.state == Job.JobState.STOPPED || this.state == Job.JobState.SUBMISSION_ERROR) {
                return;
            }
            logger.debug("Getting task status in setState()");
            File squeueResultFile = null;
            try {
                Job job;
                SoftwareDescription sd = new SoftwareDescription();
                sd.setExecutable("/bin/sh");
                sd.setArguments(new String[]{"-c", "bjobs -noheader " + jobID + " | awk {' print $3 '}"});
                sd.addAttribute("sandbox.useroot", (Object)"true");
                squeueResultFile = File.createTempFile("GAT", "tmp");
                try {
                    sd.setStdout(GAT.createFile((GATContext)this.subContext, (URI)new URI("file:///" + squeueResultFile.getAbsolutePath().replace(File.separatorChar, '/'))));
                }
                catch (Throwable e1) {
                    throw new GATInvocationException("Could not create GAT object for temporary " + squeueResultFile.getAbsolutePath(), e1);
                }
                JobDescription jd = new JobDescription(sd);
                Job job2 = job = this.jobHelper.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
                synchronized (job2) {
                    while (job.getState() != Job.JobState.STOPPED && job.getState() != Job.JobState.SUBMISSION_ERROR) {
                        try {
                            job.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                if (job.getState() != Job.JobState.STOPPED || job.getExitStatus() != 0) {
                    throw new GATInvocationException("Could not submit squeue job " + sd.toString());
                }
                BufferedReader in = new BufferedReader(new FileReader(squeueResultFile.getAbsolutePath()));
                String status = in.readLine();
                if (status == null) {
                    status = "";
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("squeue line: " + status);
                }
                resultState = this.mapLSFStatetoGAT(status);
            }
            catch (IOException e) {
                logger.debug("retrieving job status sshslurmjob failed", (Throwable)e);
                throw new GATInvocationException("Unable to retrieve the Job Status", (Throwable)e);
            }
            finally {
                squeueResultFile.delete();
            }
        }
        finally {
            SshLSFJob e = this;
            synchronized (e) {
                this.jobStateBusy = false;
                ((Object)((Object)this)).notifyAll();
            }
        }
        if (resultState != Job.JobState.STOPPED) {
            this.setState(resultState);
        } else {
            this.setState(Job.JobState.POST_STAGING);
        }
    }

    private Job.JobState mapLSFStatetoGAT(String slurmState) {
        if (slurmState == null) {
            logger.error("Error in mapLSFStatetoGAT: no SlurmState returned");
            return Job.JobState.UNKNOWN;
        }
        if (slurmState.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("no job status information for '" + this.jobID + "' found.");
            }
            if (this.sawJob) {
                if (logger.isDebugEnabled()) {
                    logger.debug("But is was present earlier, so we assume it finished.");
                }
                return Job.JobState.STOPPED;
            }
            ++this.missedJob;
            if (this.missedJob > 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("But is was not present for a while, so we assume it finished.");
                }
                return Job.JobState.STOPPED;
            }
            return this.state;
        }
        this.sawJob = true;
        if (logger.isDebugEnabled()) {
            logger.debug("slurmState = " + slurmState);
        }
        if (slurmState.equals("EXIT") || slurmState.equals("DONE")) {
            return Job.JobState.STOPPED;
        }
        if (slurmState.equals("PEND")) {
            return Job.JobState.SCHEDULED;
        }
        if (slurmState.equals("RUN")) {
            return Job.JobState.RUNNING;
        }
        if (slurmState.equals("PSUSP") || slurmState.equals("USUSP") || slurmState.equals("SSUSP")) {
            return Job.JobState.ON_HOLD;
        }
        return Job.JobState.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void kill(String jobID) {
        try {
            Job job;
            SoftwareDescription sd = new SoftwareDescription();
            sd.setExecutable("bkill");
            sd.setArguments(new String[]{jobID});
            sd.addAttribute("sandbox.useroot", (Object)"true");
            sd.addAttribute("sandbox.root", (Object)this.sandbox.getSandboxPath());
            sd.addAttribute("job.stop.on.exit", (Object)"false");
            JobDescription jd = new JobDescription(sd);
            Job job2 = job = this.jobHelper.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
            synchronized (job2) {
                while (job.getState() != Job.JobState.STOPPED && job.getState() != Job.JobState.SUBMISSION_ERROR) {
                    try {
                        job.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            if (job.getState() != Job.JobState.STOPPED || job.getExitStatus() != 0) {
                throw new GATInvocationException("Could not submit scancel job");
            }
        }
        catch (Throwable e) {
            logger.info("Failed to stop sshSlurm job: " + jobID, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Integer retrieveExitStatus(String returnValueFile) {
        String marker = "retvalue = ";
        String line = null;
        int rc = -1;
        BufferedReader rExit = null;
        File fi = new File(returnValueFile);
        try {
            rExit = new BufferedReader(new FileReader(fi));
            line = rExit.readLine().toString();
            String rc_String = line.substring(marker.length());
            if (rc_String != null) {
                rc = Integer.parseInt(rc_String);
            }
            Integer n = new Integer(rc);
            return n;
        }
        catch (Exception e) {
            logger.debug("SshLsf adaptor: error reading exit value file " + returnValueFile, (Throwable)e);
            Integer n = null;
            return n;
        }
        finally {
            try {
                rExit.close();
            }
            catch (Throwable e) {}
            fi.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMetricEvent(MetricEvent event) {
        if (event.getValue().equals(Job.JobState.STOPPED) || event.getValue().equals(Job.JobState.SUBMISSION_ERROR)) {
            Object object = event.getSource();
            synchronized (object) {
                event.getSource().notifyAll();
            }
        }
    }
}

