/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.util.Map;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.SerializedJob;

public class SerializedSimpleJobBase
extends SerializedJob {
    private static final long serialVersionUID = 1L;
    private String stdout;
    private String stderr;
    private String[] toStageOut;
    private String[] stagedOut;
    private String brokerURI;
    private String returnValueFile;

    public SerializedSimpleJobBase() {
    }

    public SerializedSimpleJobBase(String classname, JobDescription jobDescription, Sandbox sandbox, String jobId, long submissiontime, long starttime, long stoptime, SoftwareDescription sd, URI brokerURI, String returnValueFile) {
        super(classname, jobDescription, sandbox, jobId, submissiontime, starttime, stoptime);
        Map postStaged;
        this.brokerURI = brokerURI.toString();
        this.returnValueFile = returnValueFile;
        File s = sd.getStdout();
        if (s != null) {
            this.stdout = s.getAbsolutePath();
        }
        if ((s = sd.getStderr()) != null) {
            this.stderr = s.getAbsolutePath();
        }
        if ((postStaged = sd.getPostStaged()) != null) {
            int sz = postStaged.keySet().size();
            this.toStageOut = new String[sz];
            this.stagedOut = new String[sz];
            int index = 0;
            for (File srcFile : postStaged.keySet()) {
                File destFile = (File)postStaged.get(srcFile);
                this.toStageOut[index] = srcFile.getName();
                this.stagedOut[index] = destFile == null ? srcFile.getName() : SerializedSimpleJobBase.realPath(destFile.toGATURI());
                if (logger.isDebugEnabled()) {
                    logger.debug("Poststage: src = " + this.toStageOut[index] + ", dest = " + this.stagedOut[index]);
                }
                ++index;
            }
        }
    }

    public static synchronized String realPath(URI uri) {
        String path = null;
        String stringURI = null;
        stringURI = uri.toString();
        int pathBegin = stringURI.indexOf("://");
        path = pathBegin != -1 ? stringURI.substring(pathBegin + 3) : stringURI;
        if (SerializedSimpleJobBase.isWindowsPath(path)) {
            return path;
        }
        return uri.getPath();
    }

    private static boolean isWindowsPath(String s) {
        String subStr = s.substring(0, 2);
        return subStr.matches("[a-zA-Z][:]");
    }

    public String getStdout() {
        return this.stdout;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public String[] getToStageOut() {
        return this.toStageOut;
    }

    public void setToStageOut(String[] toStageOut) {
        this.toStageOut = toStageOut;
    }

    public String[] getStagedOut() {
        return this.stagedOut;
    }

    public void setStagedOut(String[] stagedOut) {
        this.stagedOut = stagedOut;
    }

    public String getBrokerURI() {
        return this.brokerURI;
    }

    public void setBrokerURI(String brokerURI) {
        this.brokerURI = brokerURI;
    }

    public String getReturnValueFile() {
        return this.returnValueFile;
    }

    public void setReturnValueFile(String returnValueFile) {
        this.returnValueFile = returnValueFile;
    }
}

