/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.engine.util.ScheduledExecutor;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.SerializedSimpleJobBase;

public abstract class SimpleJobBase
extends JobCpi {
    private static final long serialVersionUID = 1L;
    protected String jobID;
    private MetricDefinition statusMetricDefinition;
    private Metric statusMetric;
    private SoftwareDescription Soft;
    private JobListener jsl;
    private Integer exitStatus = null;
    protected URI brokerURI;
    private final String returnValueFile;

    protected SimpleJobBase(GATContext gatContext, URI brokerURI, JobDescription jobDescription, Sandbox sandbox, String returnValueFile) {
        super(gatContext, jobDescription, sandbox);
        this.returnValueFile = returnValueFile;
        this.brokerURI = brokerURI;
        this.state = Job.JobState.INITIAL;
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "String", null, null, returnDef);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
    }

    protected SimpleJobBase(GATContext gatContext, SerializedSimpleJobBase sj) throws GATObjectCreationException {
        super(gatContext, sj.getJobDescription(), sj.getSandbox());
        if (this.sandbox != null) {
            this.sandbox.setContext(gatContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("reconstructing Job: " + sj);
        }
        try {
            this.brokerURI = new URI(sj.getBrokerURI());
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("Could not create brokerURI", (Throwable)e);
        }
        this.returnValueFile = sj.getReturnValueFile();
        this.jobID = sj.getJobId();
        this.starttime = sj.getStarttime();
        this.stoptime = sj.getStoptime();
        this.submissiontime = sj.getSubmissiontime();
        this.Soft = new SoftwareDescription();
        String s = sj.getStdout();
        if (s != null) {
            this.Soft.setStdout(GAT.createFile((GATContext)gatContext, (String)s));
        }
        if ((s = sj.getStderr()) != null) {
            this.Soft.setStderr(GAT.createFile((GATContext)gatContext, (String)s));
        }
        String[] toStageOut = sj.getToStageOut();
        String[] stagedOut = sj.getStagedOut();
        if (toStageOut != null) {
            for (int i = 0; i < toStageOut.length; ++i) {
                this.Soft.addPostStagedFile(GAT.createFile((GATContext)gatContext, (String)toStageOut[i]), GAT.createFile((GATContext)gatContext, (String)stagedOut[i]));
            }
        }
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "String", null, null, returnDef);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
    }

    protected abstract void getJobState(String var1) throws GATInvocationException;

    protected abstract void kill(String var1);

    protected abstract Integer retrieveExitStatus(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(Job.JobState state) {
        SimpleJobBase simpleJobBase = this;
        synchronized (simpleJobBase) {
            if (this.submissiontime == 0L) {
                this.setSubmissionTime();
            }
            if (this.state != state) {
                this.state = state;
                if ((state == Job.JobState.RUNNING || state == Job.JobState.POST_STAGING || state == Job.JobState.STOPPED) && this.starttime == 0L) {
                    this.setStartTime();
                }
                if (state == Job.JobState.STOPPED) {
                    this.setStopTime();
                }
                MetricEvent v = new MetricEvent((Object)this, (Object)state, this.statusMetric, System.currentTimeMillis());
                this.fireMetric(v);
            }
        }
    }

    protected synchronized void setJobID(String jobID) {
        this.jobID = jobID;
        this.notifyAll();
    }

    protected void startListener() {
        this.jsl = new JobListener(this.jobID, this.Soft);
        ScheduledExecutor.schedule(this.jsl, 10L);
    }

    @Override
    public synchronized Job.JobState getState() {
        if (this.jobID != null) {
            try {
                this.getJobState(this.jobID);
            }
            catch (Throwable e) {
                logger.debug("setState failed in getState", e);
            }
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String marshal() {
        SerializedSimpleJobBase sj;
        SimpleJobBase simpleJobBase = this;
        synchronized (simpleJobBase) {
            while (this.state == Job.JobState.INITIAL || this.state == Job.JobState.PRE_STAGING) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            sj = new SerializedSimpleJobBase(this.getClass().getName(), this.jobDescription, this.sandbox, this.jobID, this.submissiontime, this.starttime, this.stoptime, this.Soft, this.brokerURI, this.returnValueFile);
        }
        String res = GATEngine.defaultMarshal(sj);
        if (logger.isDebugEnabled()) {
            logger.debug("marshalled seralized job: " + res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Advertisable unmarshal(GATContext context, String s, ClassLoader classLoader) throws GATObjectCreationException {
        if (logger.isDebugEnabled()) {
            logger.debug("unmarshalled seralized job: " + s);
        }
        SerializedSimpleJobBase sj = (SerializedSimpleJobBase)GATEngine.defaultUnmarshal(SerializedSimpleJobBase.class, s);
        Class<JobCpi> clazz = JobCpi.class;
        synchronized (JobCpi.class) {
            for (int i = 0; i < jobList.size(); ++i) {
                JobCpi j = (JobCpi)jobList.get(i);
                if (!(j instanceof SimpleJobBase)) continue;
                SimpleJobBase gj = (SimpleJobBase)j;
                if (!sj.getJobId().equals(gj.getJobID())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("returning existing job: " + gj);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return gj;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            String jobClass = sj.getClassname();
            try {
                Class<?> cl = Class.forName(jobClass, true, classLoader);
                return (Advertisable)cl.getConstructor(GATContext.class, SerializedSimpleJobBase.class).newInstance(context, sj);
            }
            catch (Throwable e) {
                throw new GATObjectCreationException("Could not deserialize job", e);
            }
        }
    }

    protected void setSoft(SoftwareDescription Soft) {
        this.Soft = Soft;
    }

    @Override
    public void stop() throws GATInvocationException {
        try {
            this.getJobState(this.jobID);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.state == Job.JobState.POST_STAGING || this.state == Job.JobState.STOPPED || this.state == Job.JobState.SUBMISSION_ERROR) {
            return;
        }
        if (this.state != Job.JobState.RUNNING && this.state != Job.JobState.ON_HOLD && this.state != Job.JobState.SCHEDULED) {
            throw new GATInvocationException("Cant stop(): job is not in a running state");
        }
        this.jsl.stop(!this.gatContext.getPreferences().containsKey("job.stop.poststage") || !this.gatContext.getPreferences().get("job.stop.poststage").equals("false"));
        this.state = Job.JobState.STOPPED;
        if (this.stoptime == 0L) {
            this.stoptime = System.currentTimeMillis();
        }
        logger.debug("Job " + this.jobID + " stopped by user");
    }

    private synchronized void poststageFiles(SoftwareDescription sd) {
        this.setState(Job.JobState.POST_STAGING);
        this.sandbox.retrieveAndCleanup(this);
        this.exitStatus = this.retrieveExitStatus(this.returnValueFile);
    }

    @Override
    public synchronized int getExitStatus() throws GATInvocationException {
        if (this.state != Job.JobState.STOPPED && this.state != Job.JobState.SUBMISSION_ERROR) {
            throw new GATInvocationException("not in STOPPED or SUBMISSION_ERROR state");
        }
        if (this.exitStatus != null) {
            return this.exitStatus;
        }
        return -1;
    }

    @Override
    public Map<String, Object> getInfo() throws GATInvocationException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.state != Job.JobState.STOPPED && this.state != Job.JobState.POST_STAGING && this.state != Job.JobState.SUBMISSION_ERROR) {
            try {
                this.getJobState(this.jobID);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        m.put("adaptor.job.id", this.jobID);
        if (this.state == Job.JobState.RUNNING) {
            String host = this.brokerURI.getHost();
            if (host == null) {
                host = "localhost";
            }
            m.put("hostname", host);
        } else {
            m.put("hostname", null);
        }
        m.put("state", this.state.toString());
        if (this.state == Job.JobState.INITIAL || this.state == Job.JobState.UNKNOWN || this.state == Job.JobState.SCHEDULED) {
            m.put("starttime", null);
        } else {
            m.put("starttime", this.starttime);
        }
        if (this.state != Job.JobState.STOPPED) {
            m.put("stoptime", null);
        } else {
            m.put("stoptime", this.stoptime);
        }
        if (this.submissiontime != 0L) {
            m.put("submissiontime", this.submissiontime);
        } else {
            m.put("submissiontime", null);
        }
        m.put("poststage.exception", (Object)this.postStageException);
        if (this.deleteException != null) {
            m.put("delete.exception", (Object)this.deleteException);
        }
        if (this.wipeException != null) {
            m.put("wipe.exception", (Object)this.wipeException);
        }
        return m;
    }

    private class JobListener
    implements Runnable {
        final int SLEEP = 5000;
        String jobID = null;
        SoftwareDescription Soft = null;
        private boolean terminated;
        private boolean finished;

        public JobListener(String jobID, SoftwareDescription Soft) {
            this.jobID = jobID;
            this.Soft = Soft;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                try {
                    SimpleJobBase.this.getJobState(this.jobID);
                }
                catch (GATInvocationException e) {
                    if (JobCpi.logger.isDebugEnabled()) {
                        JobCpi.logger.debug("GATInvocationException caught in jobListener", (Throwable)e);
                    }
                    if (SimpleJobBase.this.state == Job.JobState.STOPPED || SimpleJobBase.this.state == Job.JobState.POST_STAGING) break block12;
                    SimpleJobBase.this.setState(Job.JobState.SUBMISSION_ERROR);
                }
            }
            if (SimpleJobBase.this.state == Job.JobState.SUBMISSION_ERROR) {
                JobCpi.logger.error("Job " + this.jobID + " failed");
                JobListener jobListener = this;
                synchronized (jobListener) {
                    this.finished = true;
                    this.notifyAll();
                }
                return;
            }
            if (SimpleJobBase.this.state == Job.JobState.STOPPED || SimpleJobBase.this.state == Job.JobState.POST_STAGING) {
                this.terminate(true, true);
                JobListener jobListener = this;
                synchronized (jobListener) {
                    this.finished = true;
                    this.notifyAll();
                }
            } else {
                ScheduledExecutor.schedule(this, 5000L);
            }
        }

        private synchronized void terminate(boolean fromThread, boolean mustPoststage) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (!fromThread) {
                while (!this.finished) {
                    try {
                        this.wait();
                    }
                    catch (Throwable e) {}
                }
            }
            if (mustPoststage) {
                SimpleJobBase.this.setState(Job.JobState.POST_STAGING);
                SimpleJobBase.this.poststageFiles(this.Soft);
            }
            SimpleJobBase.this.setState(Job.JobState.STOPPED);
            SimpleJobBase.this.finished();
            try {
                SimpleJobBase.this.getExitStatus();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (JobCpi.logger.isInfoEnabled()) {
                JobCpi.logger.info("Finished job ID: " + this.jobID);
            }
        }

        public void stop(boolean mustPoststage) {
            SimpleJobBase.this.kill(this.jobID);
            if (JobCpi.logger.isDebugEnabled()) {
                JobCpi.logger.debug("SshPbs Job " + this.jobID + " stopped by user");
            }
            this.terminate(false, mustPoststage);
        }
    }
}

