/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.monitoring.cpi.MonitorableCpi;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.HardwareResource;
import org.gridlab.gat.resources.HardwareResourceDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.WrapperJob;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.WrappedJobCpi;

public class WrapperJobCpi
extends MonitorableCpi
implements WrapperJob,
MetricListener {
    protected final int jobID = JobCpi.allocJobID();
    protected GATContext gatContext;
    private Job wrapperJob;
    private int wrapperJobIndex = -1;
    private Metric metric = null;
    private Map<JobDescription, WrappedJobCpi> wrappedJobs = new HashMap<JobDescription, WrappedJobCpi>();

    public WrapperJobCpi(GATContext gatContext, Job wrapperJob, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        this.gatContext = gatContext;
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        MetricDefinition statusMetricDefinition = new MetricDefinition("job.status", 2, "JobState", null, null, returnDef);
        this.registerMetric("getJobStatus", statusMetricDefinition);
        this.wrapperJob = wrapperJob;
        WrapperJobDescription wrapperDescription = (WrapperJobDescription)wrapperJob.getJobDescription();
        for (WrapperJobDescription.WrappedJobInfo info : wrapperDescription.getJobInfos()) {
            WrappedJobCpi wrappedJob = new WrappedJobCpi(gatContext, info, this);
            this.wrappedJobs.put(info.getJobDescription(), wrappedJob);
            this.wrapperJobIndex = info.getWrapperJobIndex();
        }
        if (listener != null && metricDefinitionName != null) {
            this.metric = this.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
            this.addMetricListener(listener, this.metric);
        }
    }

    public int getJobID() {
        return this.jobID;
    }

    Job getWrapperJob() {
        return this.wrapperJob;
    }

    public Job getJob(JobDescription description) throws GATInvocationException {
        return this.wrappedJobs.get(description);
    }

    public void checkpoint() throws GATInvocationException {
        this.wrapperJob.checkpoint();
    }

    public Job cloneJob(HardwareResource resource) {
        return this.wrapperJob.cloneJob(resource);
    }

    public int getExitStatus() throws GATInvocationException {
        return this.wrapperJob.getExitStatus();
    }

    public Map<String, Object> getInfo() throws GATInvocationException {
        return this.wrapperJob.getInfo();
    }

    public AbstractJobDescription getJobDescription() {
        return this.wrapperJob.getJobDescription();
    }

    public Job.JobState getState() {
        return this.wrapperJob.getState();
    }

    public InputStream getStderr() throws GATInvocationException {
        return this.wrapperJob.getStderr();
    }

    public OutputStream getStdin() throws GATInvocationException {
        return this.wrapperJob.getStdin();
    }

    public InputStream getStdout() throws GATInvocationException {
        return this.wrapperJob.getStdout();
    }

    public void hold() throws GATInvocationException {
        this.wrapperJob.hold();
    }

    public void migrate() throws GATInvocationException {
        this.wrapperJob.migrate();
    }

    public void migrate(HardwareResourceDescription hardwareResourceDescription) throws GATInvocationException {
        this.wrapperJob.migrate(hardwareResourceDescription);
    }

    public void resume() throws GATInvocationException {
        this.wrapperJob.resume();
    }

    public void stop() throws GATInvocationException {
        this.wrapperJob.stop();
    }

    public void unSchedule() throws GATInvocationException {
        this.wrapperJob.unSchedule();
    }

    public String marshal() {
        return this.wrapperJob.marshal();
    }

    public void processMetricEvent(MetricEvent event) {
        MetricEvent e;
        if (event.getSource() == this.wrapperJob) {
            if (logger.isDebugEnabled()) {
                logger.debug("Event source is wrapper job");
            }
            e = new MetricEvent((Object)this, event.getValue(), this.metric, event.getEventTime());
        } else {
            e = event;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("forwarding metric event " + e);
        }
        this.fireMetric(e);
    }

    public String toString() {
        return "Wrapper job, index " + this.wrapperJobIndex + ", id is " + this.jobID;
    }
}

