/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.sshtrilead;

import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.cpi.sshtrilead.SshTrileadFileAdaptor;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.ResourceBrokerCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;
import org.gridlab.gat.resources.cpi.sshtrilead.SshTrileadJob;
import org.gridlab.gat.security.sshtrilead.HostKeyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshTrileadResourceBrokerAdaptor
extends ResourceBrokerCpi {
    protected static Logger logger = LoggerFactory.getLogger(SshTrileadResourceBrokerAdaptor.class);
    public static final int IN = 0;
    public static final int ERR = 1;
    public static final int OUT = 2;
    public static final int SSH_PORT = 22;
    private boolean connectionCacheEnable;
    private String[] client2serverCiphers;
    private String[] server2clientCiphers;
    private final boolean tcpNoDelay;
    private final boolean isWindowsCacheEnable;
    private final boolean isCshCacheEnable;
    private boolean isWindows;
    private HostKeyVerifier verifier;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = ResourceBrokerCpi.getSupportedCapabilities();
        capabilities.put("beginMultiJob", true);
        capabilities.put("endMultiJob", true);
        capabilities.put("submitJob", true);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = ResourceBrokerCpi.getSupportedPreferences();
        preferences.put("sshtrilead.cipher.client2server", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.cipher.server2client", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.tcp.nodelay", (Object)"false");
        preferences.put("sshtrilead.use.cached.connections", (Object)"true");
        preferences.put("sshtrilead.separate.output", (Object)"false");
        preferences.put("sshtrilead.stoppable", (Object)"false");
        preferences.put("sshtrilead.caching.iswindows", (Object)"true");
        preferences.put("sshtrilead.caching.iscsh", (Object)"true");
        preferences.put("sshtrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sshtrilead.noHostKeyChecking", (Object)"true");
        return preferences;
    }

    public static String getDescription() {
        return "The SshTrilead ResourceBroker Adaptor implements the ResourceBroker object using the trilead ssh library. Trilead ssh is an open source full java ssh library. The ssh trilead ResourceBroker adaptor can only submit to single machines, however if you invoke a command like 'qsub' on a headnode, it might result in an application running on multiple machines. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"sshtrilead", "ssh"};
    }

    public SshTrileadResourceBrokerAdaptor(GATContext gatContext, URI brokerURI) throws Exception {
        super(gatContext, brokerURI);
        boolean noHostKeyChecking = true;
        boolean strictHostKeyChecking = false;
        Preferences p = gatContext.getPreferences();
        String client2serverCipherString = (String)p.get("sshtrilead.cipher.client2server", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        this.client2serverCiphers = client2serverCipherString.split(",");
        String server2clientCipherString = (String)p.get("sshtrilead.cipher.server2client", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        this.server2clientCiphers = server2clientCipherString.split(",");
        this.tcpNoDelay = ((String)p.get("sshtrilead.tcp.nodelay", (Object)"true")).equalsIgnoreCase("true");
        this.connectionCacheEnable = ((String)p.get("sshtrilead.use.cached.connections", (Object)"true")).equalsIgnoreCase("true");
        this.isWindowsCacheEnable = ((String)p.get("sshtrilead.caching.iswindows", (Object)"true")).equalsIgnoreCase("true");
        this.isCshCacheEnable = ((String)p.get("sshtrilead.caching.iscsh", (Object)"true")).equalsIgnoreCase("true");
        noHostKeyChecking = ((String)p.get("sshtrilead.noHostKeyChecking", (Object)"true")).equalsIgnoreCase("true");
        strictHostKeyChecking = ((String)p.get("sshtrilead.strictHostKeyChecking", (Object)"false")).equalsIgnoreCase("true");
        this.verifier = new HostKeyVerifier(false, strictHostKeyChecking, noHostKeyChecking);
        this.isWindows = SshTrileadFileAdaptor.isWindows(gatContext, brokerURI, this.isWindowsCacheEnable);
    }

    public Job submitJob(AbstractJobDescription abstractDescription, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        Map env;
        if (!(abstractDescription instanceof JobDescription)) {
            throw new GATInvocationException("can only handle JobDescriptions: " + abstractDescription.getClass());
        }
        JobDescription description = (JobDescription)abstractDescription;
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        if (description.getProcessCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: process count > 1: " + description.getProcessCount());
        }
        if (description.getResourceCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: resource count > 1: " + description.getResourceCount());
        }
        boolean separateOutput = "true".equalsIgnoreCase((String)this.gatContext.getPreferences().get("sshtrilead.separate.output"));
        boolean stoppable = "true".equalsIgnoreCase((String)this.gatContext.getPreferences().get("sshtrilead.stoppable"));
        if (stoppable && separateOutput) {
            throw new GATInvocationException("The preferences 'sshtrilead.separate.output' and 'sshtrilead.stoppable' cannot both be set to 'true'.");
        }
        Sandbox sandbox = new Sandbox(this.gatContext, description, this.getAuthority(), null, true, false, false, false);
        SshTrileadJob sshJob = new SshTrileadJob(this.gatContext, description, sandbox);
        SshTrileadJob job = null;
        if (description instanceof WrapperJobDescription) {
            WrapperJobCpi tmp = new WrapperJobCpi(this.gatContext, (Job)sshJob, listener, metricDefinitionName);
            listener = tmp;
            job = tmp;
        } else {
            job = sshJob;
        }
        if (listener != null && metricDefinitionName != null) {
            Metric metric = sshJob.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
            sshJob.addMetricListener(listener, metric);
        }
        sshJob.setState(Job.JobState.PRE_STAGING);
        sandbox.prestage();
        String command = "";
        if (sandbox.getSandboxPath() != null) {
            command = command + "cd " + sandbox.getSandboxPath() + (this.isWindows ? " & " : " && ");
        }
        if ((env = sd.getEnvironment()) != null && !env.isEmpty()) {
            if (this.isWindows) {
                throw new GATInvocationException("environment not supported for windows");
            }
            Set s = env.keySet();
            Object[] keys = s.toArray();
            boolean isCsh = SshTrileadFileAdaptor.isCsh(this.gatContext, this.brokerURI, this.isCshCacheEnable);
            for (int i = 0; i < keys.length; ++i) {
                String val = (String)env.get(keys[i]);
                command = isCsh ? command + "set " + keys[i] + "=" + val + " && " : command + keys[i] + "=" + val + " && export " + keys[i] + " && ";
            }
        }
        String exec = this.getExecutable(description);
        if (this.isWindows && exec.contains(" ")) {
            exec = "\"" + exec + "\"";
        }
        command = command + (this.isWindows ? exec : "exec " + SshTrileadResourceBrokerAdaptor.protectAgainstShellMetas(exec));
        String[] args = this.getArgumentsArray(description);
        if (args != null) {
            for (String arg : args) {
                if (this.isWindows) {
                    if (arg.contains(" ")) {
                        arg = "\"" + arg + "\"";
                    }
                    command = command + " " + arg;
                    continue;
                }
                command = command + " " + SshTrileadResourceBrokerAdaptor.protectAgainstShellMetas(arg);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("running command: " + command);
        }
        Session session = null;
        try {
            try {
                session = SshTrileadFileAdaptor.getConnection(this.brokerURI, this.gatContext, this.connectionCacheEnable, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier).openSession();
            }
            catch (IOException e) {
                session = SshTrileadFileAdaptor.getConnection(this.brokerURI, this.gatContext, false, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier).openSession();
            }
            if (stoppable) {
                logger.info("starting dumb pty");
                session.requestDumbPTY();
            }
        }
        catch (Exception e) {
            throw new GATInvocationException("Unable to connect!", (Throwable)e);
        }
        StreamForwarder stdout = null;
        StreamForwarder stderr = null;
        if (!sd.streamingStderrEnabled()) {
            try {
                if (sd.getStderr() != null) {
                    stderr = new StreamForwarder(session.getStderr(), (OutputStream)GAT.createFileOutputStream((File)sd.getStderr()));
                } else {
                    new StreamForwarder(session.getStderr(), null);
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stderr!", (Throwable)e);
            }
        }
        if (!sd.streamingStdoutEnabled()) {
            try {
                if (sd.getStdout() != null) {
                    stdout = new StreamForwarder(session.getStdout(), (OutputStream)GAT.createFileOutputStream((File)sd.getStdout()));
                } else {
                    new StreamForwarder(session.getStdout(), null);
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stdout!", (Throwable)e);
            }
        }
        if (!sd.streamingStdinEnabled() && sd.getStdin() != null) {
            try {
                new StreamForwarder((InputStream)GAT.createFileInputStream((File)sd.getStdin()), session.getStdin());
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file input stream for stdin!", (Throwable)e);
            }
        }
        sshJob.setSession(session);
        sshJob.monitorState(stdout, stderr);
        try {
            session.execCommand(command);
        }
        catch (IOException e) {
            throw new GATInvocationException("execution failed!", (Throwable)e);
        }
        sshJob.setSubmissionTime();
        sshJob.setStartTime();
        sshJob.setState(Job.JobState.RUNNING);
        return job;
    }

    private static String protectAgainstShellMetas(String s) {
        char[] chars = s.toCharArray();
        StringBuffer b = new StringBuffer();
        b.append('\'');
        for (char c : chars) {
            if (c == '\'') {
                b.append('\'');
                b.append('\\');
                b.append('\'');
            }
            b.append(c);
        }
        b.append('\'');
        return b.toString();
    }
}

