/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.master;

import integratedtoolkit.comm.CommAdaptor;
import integratedtoolkit.comm.Dispatcher;
import integratedtoolkit.gat.master.GATJob;
import integratedtoolkit.gat.master.GATWorkerNode;
import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.data.operation.Copy;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.RequestQueue;
import integratedtoolkit.util.ThreadPool;
import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.URI;

public class GATAdaptor
implements CommAdaptor {
    public static final String ID = GATAdaptor.class.getCanonicalName();
    private static final int GAT_POOL_SIZE = 5;
    protected static final String POOL_NAME = "FTM";
    protected static final String SAFE_POOL_NAME = "SAFE_FTM";
    protected static final String THREAD_POOL_ERR = "Error starting pool of threads";
    protected static final String POOL_ERR = "Error deleting pool of threads";
    protected static final int SAFE_POOL_SIZE = 1;
    public static RequestQueue<DataOperation> copyQueue;
    public static RequestQueue<DataOperation> safeQueue;
    protected static ThreadPool pool;
    protected static ThreadPool safePool;
    private static String masterUser;
    private static GATContext transferContext;
    private static final Logger logger;
    private static final boolean debug;

    @Override
    public void init() {
        copyQueue = new RequestQueue();
        safeQueue = new RequestQueue();
        String adaptor = System.getProperty("it.gat.file.adaptor");
        if (debug) {
            logger.debug("Initializing GAT");
        }
        pool = new ThreadPool(5, POOL_NAME, new Dispatcher(copyQueue));
        try {
            pool.startThreads();
        }
        catch (Exception e) {
            ErrorManager.error(THREAD_POOL_ERR, e);
        }
        safePool = new ThreadPool(1, SAFE_POOL_NAME, new Dispatcher(safeQueue));
        try {
            safePool.startThreads();
        }
        catch (Exception e) {
            ErrorManager.error(THREAD_POOL_ERR, e);
        }
        if (debug) {
            logger.debug("Initializing GAT Tranfer Context");
        }
        transferContext = new GATContext();
        transferContext.addPreference("File.adaptor.name", adaptor + ", srcToLocalToDestCopy, local");
    }

    @Override
    public GATWorkerNode initWorker(String name, HashMap<String, String> properties, TreeMap<String, AdaptorDescription> adaptorsDesc) {
        logger.debug("There are " + adaptorsDesc.size() + "descriptions.\n" + adaptorsDesc.toString());
        GATWorkerNode node = new GATWorkerNode(name, properties, adaptorsDesc.get("integratedtoolkit.gat.master.GATAdaptor"));
        return node;
    }

    public static void addTransferContextPreferences(String name, String value) {
        transferContext.addPreference(name, value);
    }

    @Override
    public LinkedList<DataOperation> getPending() {
        LinkedList<DataOperation> l = new LinkedList<DataOperation>();
        for (DataOperation c : copyQueue.getQueue()) {
            l.add(c);
        }
        for (DataOperation c : safeQueue.getQueue()) {
            l.add(c);
        }
        return l;
    }

    @Override
    public void stop() {
        try {
            pool.stopThreads();
            safePool.stopThreads();
        }
        catch (Exception e) {
            logger.error(POOL_ERR, e);
        }
        GAT.end();
    }

    @Override
    public void stopSubmittedJobs() {
        GATJob.stopAll();
    }

    @Override
    public void completeMasterURI(integratedtoolkit.types.data.location.URI uri) {
        String scheme = uri.getScheme();
        String user = masterUser + "@";
        String host = uri.getHost().getName();
        String path = uri.getPath();
        if (!path.contains(File.separator)) {
            return;
        }
        String s = scheme + user + host + File.separator + path;
        try {
            uri.setInternalURI(ID, new URI(s));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void enqueueCopy(Copy c) {
        copyQueue.enqueue(c);
    }

    public static GATContext getTransferContext() {
        return transferContext;
    }

    static {
        masterUser = System.getProperty("user.name");
        logger = Logger.getLogger("integratedtoolkit.Communication");
        debug = logger.isDebugEnabled();
    }
}

