/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.resources.Resource;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

class Machine {
    Resource resource;
    LinkedList<String> allShared;
    HashMap<String, String> mountpoint2Name;
    HashMap<String, String> name2Mountpoint;

    public Machine(Resource resource) {
        this.resource = resource;
        this.allShared = new LinkedList();
        this.mountpoint2Name = new HashMap();
        this.name2Mountpoint = new HashMap();
    }

    public void addSharedDisk(String diskName, String mountpoint) {
        this.allShared.add(diskName);
        if (!mountpoint.endsWith(File.separator)) {
            mountpoint = mountpoint + File.separator;
        }
        this.mountpoint2Name.put(mountpoint, diskName);
        this.name2Mountpoint.put(diskName, mountpoint);
    }

    public String getSharedName(String path) {
        if (path == null) {
            return null;
        }
        for (Map.Entry<String, String> e : this.mountpoint2Name.entrySet()) {
            if (!path.startsWith(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    public String getPath(String sharedDisk) {
        return this.name2Mountpoint.get(sharedDisk);
    }

    public String getPath(LinkedList<String> sharedDisks) {
        for (int i = 0; i < sharedDisks.size(); ++i) {
            String path = this.name2Mountpoint.get(sharedDisks.get(i));
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public LinkedList<String> getAllSharedNames() {
        return this.allShared;
    }
}

