/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.util.CoreManager;
import java.io.Serializable;

public class TaskParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Integer coreId;
    private final String methodName;
    private final Parameter[] parameters;
    private final boolean priority;
    private final boolean hasTarget;
    private final boolean hasReturn;
    private final Type type;

    public TaskParams(String methodClass, String methodName, boolean priority, boolean hasTarget, Parameter[] parameters) {
        Parameter lastParam;
        this.methodName = methodName;
        this.priority = priority;
        this.hasTarget = hasTarget;
        this.parameters = parameters;
        this.hasReturn = parameters.length == 0 ? false : (lastParam = parameters[parameters.length - 1]).getDirection() == ITExecution.ParamDirection.OUT && lastParam.getType() == ITExecution.ParamType.OBJECT_T;
        this.coreId = CoreManager.getCoreId(methodClass, methodName, hasTarget, this.hasReturn, parameters);
        this.type = Type.METHOD;
    }

    public TaskParams(String namespace, String service, String port, String operation, boolean priority, boolean hasTarget, Parameter[] parameters) {
        Parameter lastParam;
        this.methodName = operation;
        this.priority = priority;
        this.hasTarget = hasTarget;
        this.parameters = parameters;
        this.hasReturn = parameters.length == 0 ? false : (lastParam = parameters[parameters.length - 1]).getDirection() == ITExecution.ParamDirection.OUT && lastParam.getType() == ITExecution.ParamType.OBJECT_T;
        this.coreId = CoreManager.getCoreId(namespace, service, port, operation, hasTarget, this.hasReturn, parameters);
        this.type = Type.SERVICE;
    }

    public Integer getId() {
        return this.coreId;
    }

    public String getName() {
        return this.methodName;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public boolean hasTargetObject() {
        return this.hasTarget;
    }

    public boolean hasReturnValue() {
        return this.hasReturn;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Core id: ").append(this.getId()).append("]");
        buffer.append(", [Priority: ").append(this.hasPriority()).append("]");
        buffer.append(", [").append(this.getName()).append("(");
        int numParams = this.parameters.length;
        if (this.hasTargetObject()) {
            --numParams;
        }
        if (this.hasReturnValue()) {
            --numParams;
        }
        if (numParams > 0) {
            buffer.append((Object)this.parameters[0].getType());
            for (int i = 1; i < numParams; ++i) {
                buffer.append(", ").append((Object)this.parameters[i].getType());
            }
        }
        buffer.append(")]");
        return buffer.toString();
    }

    public static enum Type {
        SERVICE,
        METHOD;

    }
}

