/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data.operation;

import integratedtoolkit.types.data.operation.DataOperation;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class WorkersDebugInformationListener
extends DataOperation.EventListener {
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.JobManager");
    int operation = 0;
    int errors = 0;
    boolean enabled = false;
    final Semaphore sem;

    public WorkersDebugInformationListener(Semaphore sem) {
        logger.debug("Init with semaphore " + sem.toString());
        this.sem = sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        boolean failed;
        boolean finished;
        WorkersDebugInformationListener workersDebugInformationListener = this;
        synchronized (workersDebugInformationListener) {
            this.enabled = true;
            finished = this.operation == 0;
            failed = this.errors > 0;
        }
        logger.debug("enabled: " + this.enabled + ", finished: " + finished + ", failed: " + failed);
        if (finished) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
        logger.debug("adding OP (" + this.operation + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEnd(DataOperation fOp) {
        boolean enabled;
        boolean failed;
        boolean finished;
        WorkersDebugInformationListener workersDebugInformationListener = this;
        synchronized (workersDebugInformationListener) {
            --this.operation;
            finished = this.operation == 0;
            failed = this.errors > 0;
            enabled = this.enabled;
        }
        if (finished && enabled) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFailure(DataOperation fOp, Exception e) {
        boolean enabled;
        boolean finished;
        WorkersDebugInformationListener workersDebugInformationListener = this;
        synchronized (workersDebugInformationListener) {
            ++this.errors;
            --this.operation;
            finished = this.operation == 0;
            enabled = this.enabled;
        }
        if (enabled && finished) {
            this.doFailures();
        }
    }

    private void doReady() {
        this.sem.release();
    }

    private void doFailures() {
        this.sem.release();
    }
}

