/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import org.w3c.dom.Node;

public class ServiceResourceDescription
extends WorkerResourceDescription {
    private final String serviceName;
    private final String namespace;
    private final String port;

    public ServiceResourceDescription(String serviceName, String namespace, String port) {
        this.serviceName = serviceName;
        this.namespace = namespace;
        this.port = port;
    }

    public ServiceResourceDescription(Node n) {
        super(n);
        this.serviceName = "";
        this.namespace = "";
        this.port = "";
    }

    public String getPort() {
        return this.port;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public boolean canHost(Implementation<?> impl) {
        if (impl.getType() == Implementation.Type.SERVICE) {
            ServiceResourceDescription s = (ServiceResourceDescription)impl.getRequirements();
            return s.getServiceName().compareTo(this.serviceName) == 0 && s.getNamespace().compareTo(this.namespace) == 0 && s.getPort().compareTo(this.port) == 0;
        }
        return false;
    }

    public String toString() {
        return "[SERVICE NAMESPACE=" + this.namespace + " " + "SERVICE_NAME=" + this.getServiceName() + " " + "PORT=" + this.port + "]";
    }
}

