/*
 * Decompiled with CFR 0.152.
 */
package examples20;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class ResourceBrokerStreamingOutExample {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("\tUsage: bin/run_gat_app examples20.ResourceBrokerStreamingOutExample <brokerURI> (where location is a valid JavaGAT URI)\n");
            System.exit(1);
        }
        new ResourceBrokerStreamingOutExample().start(args[0]);
        GAT.end();
    }

    public void start(String brokerURI) {
        ResourceBroker broker = null;
        try {
            broker = GAT.createResourceBroker((URI)new URI(brokerURI));
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create resource broker at location '" + brokerURI + "': " + (Object)((Object)e));
            return;
        }
        catch (URISyntaxException e) {
            System.err.println("Wrong uri '" + brokerURI + "': " + e);
            return;
        }
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/usr/bin/env");
        sd.enableStreamingStdout(true);
        JobDescription jd = new JobDescription(sd);
        Job job = null;
        try {
            job = broker.submitJob((AbstractJobDescription)jd);
        }
        catch (GATInvocationException e) {
            System.err.println("Failed to submit the job: " + (Object)((Object)e));
            return;
        }
        InputStream in = null;
        try {
            in = job.getStdout();
        }
        catch (GATInvocationException e) {
            System.err.println("Failed to get the stdout stream: " + (Object)((Object)e));
            return;
        }
        while (true) {
            int i = 0;
            try {
                i = in.read();
            }
            catch (IOException e) {
                System.err.println("Failed to read: " + e);
                return;
            }
            if (i == -1) break;
            System.out.print((char)i);
        }
    }
}

