/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.copyingFileInputStream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.FileInputStreamCpi;
import org.gridlab.gat.io.cpi.commandlineSsh.CommandlineSshFileAdaptor;

public class CopyingFileInputStreamAdaptor
extends FileInputStreamCpi {
    FileInputStream in;
    File localFile;

    public static String getDescription() {
        return "The Copying FileInputStream Adaptor implements the FileInputStream object by creating a local copy of a file using the CommandlineSsh File adaptor.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileInputStreamCpi.getSupportedCapabilities();
        capabilities.put("available", true);
        capabilities.put("close", true);
        capabilities.put("mark", true);
        capabilities.put("markSupported", true);
        capabilities.put("read", true);
        capabilities.put("reset", true);
        capabilities.put("skip", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"commandlinessh", "ssh", "file", ""};
    }

    public CopyingFileInputStreamAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException {
        super(gatContext, location);
        if (location.getHost() == null) {
            throw new GATObjectCreationException("this adaptor cannot read local files");
        }
        CommandlineSshFileAdaptor f = null;
        try {
            f = new CommandlineSshFileAdaptor(gatContext, location);
        }
        catch (Exception e) {
            throw new GATObjectCreationException("copying inputstream", (Throwable)e);
        }
        try {
            File tmp = File.createTempFile("JavaGATCopyingStream", "tmp");
            String path = tmp.getPath();
            tmp.delete();
            URI dest = new URI("file:///" + path);
            f.copy(dest);
            this.localFile = new File(path);
            this.localFile.deleteOnExit();
            this.in = new FileInputStream(this.localFile);
        }
        catch (Throwable e) {
            if (this.localFile != null) {
                this.localFile.delete();
            }
            throw new GATObjectCreationException("copying inputstream", e);
        }
    }

    public int available() throws GATInvocationException {
        try {
            return this.in.available();
        }
        catch (IOException e) {
            throw new GATInvocationException("CopyingFileInputStream", (Throwable)e);
        }
    }

    public void close() throws GATInvocationException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.localFile != null) {
            this.localFile.delete();
        }
        this.localFile = null;
        this.in = null;
    }

    public int read() throws GATInvocationException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            throw new GATInvocationException("CopyingFileInputStream", (Throwable)e);
        }
    }

    public int read(byte[] arg0, int arg1, int arg2) throws GATInvocationException {
        try {
            return this.in.read(arg0, arg1, arg2);
        }
        catch (IOException e) {
            throw new GATInvocationException("CopyingFileInputStream", (Throwable)e);
        }
    }

    public int read(byte[] arg0) throws GATInvocationException {
        try {
            return this.in.read(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("CopyingFileInputStream", (Throwable)e);
        }
    }

    public void reset() throws GATInvocationException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            throw new GATInvocationException("CopyingFileInputStream", (Throwable)e);
        }
    }

    public long skip(long arg0) throws GATInvocationException {
        try {
            return this.in.skip(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("CopyingFileInputStream", (Throwable)e);
        }
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

