/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.acl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.opennebula.client.acl.RuleParseException;
import org.w3c.dom.Node;

public class Acl
extends PoolElement {
    private static final String METHOD_PREFIX = "acl.";
    private static final String ADDRULE = "acl.addrule";
    private static final String DELRULE = "acl.delrule";
    private static final Map<String, Long> USERS;
    private static final Map<String, Long> RESOURCES;
    private static final Map<String, Long> RIGHTS;

    protected Acl(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string, String string2, String string3) {
        return client.call(ADDRULE, string, string2, string3);
    }

    public static OneResponse allocate(Client client, long l, long l2, long l3) {
        return Acl.allocate(client, Long.toHexString(l), Long.toHexString(l2), Long.toHexString(l3));
    }

    public static OneResponse allocate(Client client, String string) throws RuleParseException {
        String[] stringArray = Acl.parseRule(string);
        return Acl.allocate(client, stringArray[0], stringArray[1], stringArray[2]);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELRULE, n);
    }

    public OneResponse delete() {
        return Acl.delete(this.client, this.id);
    }

    public long user() {
        long l = 0L;
        try {
            l = Long.parseLong(this.xpath("USER"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public long resource() {
        long l = 0L;
        try {
            l = Long.parseLong(this.xpath("RESOURCE"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public long rights() {
        long l = 0L;
        try {
            l = Long.parseLong(this.xpath("RIGHTS"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public String toString() {
        String string = this.xpath("STRING");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String[] parseRule(String string) throws RuleParseException {
        String[] stringArray = new String[3];
        String[] stringArray2 = string.split(" ");
        if (stringArray2.length != 3) {
            throw new RuleParseException("String needs three components: User, Resource, Rights");
        }
        stringArray[0] = Acl.parseUsers(stringArray2[0]);
        stringArray[1] = Acl.parseResources(stringArray2[1]);
        stringArray[2] = Acl.parseRights(stringArray2[2]);
        return stringArray;
    }

    private static String parseUsers(String string) throws RuleParseException {
        return Long.toHexString(Acl.calculateIds(string));
    }

    private static String parseResources(String string) throws RuleParseException {
        long l = 0L;
        String[] stringArray = string.split("/");
        if (stringArray.length != 2) {
            throw new RuleParseException("Resource '" + string + "' malformed");
        }
        for (String string2 : stringArray[0].split("\\+")) {
            if (!RESOURCES.containsKey(string2 = string2.toUpperCase())) {
                throw new RuleParseException("Resource '" + string2 + "' does not exist");
            }
            l += RESOURCES.get(string2).longValue();
        }
        return Long.toHexString(l += Acl.calculateIds(stringArray[1]));
    }

    private static String parseRights(String string) throws RuleParseException {
        long l = 0L;
        for (String string2 : string.split("\\+")) {
            if (!RIGHTS.containsKey(string2 = string2.toUpperCase())) {
                throw new RuleParseException("Right '" + string2 + "' does not exist");
            }
            l |= RIGHTS.get(string2).longValue();
        }
        return Long.toHexString(l);
    }

    private static long calculateIds(String string) throws RuleParseException {
        if (!string.matches("^([#@%]\\d+|\\*)$")) {
            throw new RuleParseException("ID string '" + string + "' malformed");
        }
        long l = USERS.get("" + string.charAt(0));
        if (string.charAt(0) != '*') {
            l += Long.parseLong(string.substring(1));
        }
        return l;
    }

    static {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("#", 0x100000000L);
        hashMap.put("@", 0x200000000L);
        hashMap.put("*", 0x400000000L);
        hashMap.put("%", 0x800000000L);
        USERS = Collections.unmodifiableMap(hashMap);
        HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
        hashMap2.put("VM", 0x1000000000L);
        hashMap2.put("HOST", 0x2000000000L);
        hashMap2.put("NET", 0x4000000000L);
        hashMap2.put("IMAGE", 0x8000000000L);
        hashMap2.put("USER", 0x10000000000L);
        hashMap2.put("TEMPLATE", 0x20000000000L);
        hashMap2.put("GROUP", 0x40000000000L);
        hashMap2.put("DATASTORE", 0x100000000000L);
        hashMap2.put("CLUSTER", 0x200000000000L);
        hashMap2.put("DOCUMENT", 0x400000000000L);
        RESOURCES = Collections.unmodifiableMap(hashMap2);
        HashMap<String, Long> hashMap3 = new HashMap<String, Long>();
        hashMap3.put("USE", 1L);
        hashMap3.put("MANAGE", 2L);
        hashMap3.put("ADMIN", 4L);
        hashMap3.put("CREATE", 8L);
        RIGHTS = Collections.unmodifiableMap(hashMap3);
    }
}

