/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vm;

import java.util.AbstractList;
import java.util.Iterator;
import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.Pool;
import org.opennebula.client.PoolElement;
import org.opennebula.client.vm.VirtualMachine;
import org.w3c.dom.Node;

public class VirtualMachinePool
extends Pool
implements Iterable<VirtualMachine> {
    private static final String ELEMENT_NAME = "VM";
    private static final String INFO_METHOD = "vmpool.info";
    private static final String MONITORING = "vmpool.monitoring";
    public static final int ALL_VM = -2;
    public static final int NOT_DONE = -1;
    private int filter;

    public VirtualMachinePool(Client client) {
        super(ELEMENT_NAME, client, INFO_METHOD);
        this.filter = -1;
    }

    public VirtualMachinePool(Client client, int n) {
        super(ELEMENT_NAME, client, INFO_METHOD);
        this.filter = n;
    }

    @Override
    public PoolElement factory(Node node) {
        return new VirtualMachine(node, this.client);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO_METHOD, n, -1, -1, -1);
    }

    public static OneResponse infoAll(Client client) {
        return client.call(INFO_METHOD, -2, -1, -1, -1);
    }

    public static OneResponse infoMine(Client client) {
        return client.call(INFO_METHOD, -3, -1, -1, -1);
    }

    public static OneResponse infoGroup(Client client) {
        return client.call(INFO_METHOD, -1, -1, -1, -1);
    }

    public static OneResponse info(Client client, int n, int n2, int n3, int n4) {
        return client.call(INFO_METHOD, n, n2, n3, n4);
    }

    public static OneResponse monitoring(Client client, int n) {
        return client.call(MONITORING, n);
    }

    @Override
    public OneResponse info() {
        OneResponse oneResponse = VirtualMachinePool.info(this.client, this.filter);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    @Override
    public OneResponse infoAll() {
        OneResponse oneResponse = VirtualMachinePool.infoAll(this.client);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    @Override
    public OneResponse infoMine() {
        OneResponse oneResponse = VirtualMachinePool.infoMine(this.client);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    @Override
    public OneResponse infoGroup() {
        OneResponse oneResponse = VirtualMachinePool.infoGroup(this.client);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse info(int n, int n2, int n3, int n4) {
        OneResponse oneResponse = VirtualMachinePool.info(this.client, n, n2, n3, n4);
        this.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse monitoring(int n) {
        return VirtualMachinePool.monitoring(this.client, n);
    }

    @Override
    public Iterator<VirtualMachine> iterator() {
        AbstractList<VirtualMachine> abstractList = new AbstractList<VirtualMachine>(){

            @Override
            public int size() {
                return VirtualMachinePool.this.getLength();
            }

            @Override
            public VirtualMachine get(int n) {
                return (VirtualMachine)VirtualMachinePool.this.item(n);
            }
        };
        return abstractList.iterator();
    }

    @Override
    public VirtualMachine getById(int n) {
        return (VirtualMachine)super.getById(n);
    }
}

