/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vnet;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class VirtualNetwork
extends PoolElement {
    private static final String METHOD_PREFIX = "vn.";
    private static final String ALLOCATE = "vn.allocate";
    private static final String INFO = "vn.info";
    private static final String DELETE = "vn.delete";
    private static final String ADDLEASES = "vn.addleases";
    private static final String RMLEASES = "vn.rmleases";
    private static final String CHOWN = "vn.chown";
    private static final String CHMOD = "vn.chmod";
    private static final String UPDATE = "vn.update";
    private static final String HOLD = "vn.hold";
    private static final String RELEASE = "vn.release";
    private static final String RENAME = "vn.rename";

    public VirtualNetwork(int n, Client client) {
        super(n, client);
    }

    protected VirtualNetwork(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string, int n) {
        return client.call(ALLOCATE, string, n);
    }

    public static OneResponse allocate(Client client, String string) {
        return VirtualNetwork.allocate(client, string, -1);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse publish(Client client, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return VirtualNetwork.chmod(client, n, -1, -1, -1, n2, -1, -1, -1, -1, -1);
    }

    public static OneResponse addLeases(Client client, int n, String string) {
        return client.call(ADDLEASES, n, string);
    }

    public static OneResponse rmLeases(Client client, int n, String string) {
        return client.call(RMLEASES, n, string);
    }

    public static OneResponse hold(Client client, int n, String string) {
        return client.call(HOLD, n, string);
    }

    public static OneResponse release(Client client, int n, String string) {
        return client.call(RELEASE, n, string);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return VirtualNetwork.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return VirtualNetwork.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return VirtualNetwork.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public OneResponse info() {
        OneResponse oneResponse = VirtualNetwork.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return VirtualNetwork.delete(this.client, this.id);
    }

    public OneResponse publish(boolean bl) {
        return VirtualNetwork.publish(this.client, this.id, bl);
    }

    public OneResponse publish() {
        return this.publish(true);
    }

    public OneResponse unpublish() {
        return this.publish(false);
    }

    public OneResponse addLeases(String string) {
        return this.addLeases(string, null);
    }

    public OneResponse addLeases(String string, String string2) {
        String string3 = "LEASES = [ IP = " + string;
        if (string2 != null) {
            string3 = string3 + ", MAC = " + string2;
        }
        string3 = string3 + " ]";
        return VirtualNetwork.addLeases(this.client, this.id, string3);
    }

    public OneResponse rmLeases(String string) {
        String string2 = "LEASES = [ IP = " + string + " ]";
        return VirtualNetwork.rmLeases(this.client, this.id, string2);
    }

    public OneResponse hold(String string) {
        String string2 = "LEASES = [ IP = " + string + " ]";
        return VirtualNetwork.hold(this.client, this.id, string2);
    }

    public OneResponse release(String string) {
        String string2 = "LEASES = [ IP = " + string + " ]";
        return VirtualNetwork.release(this.client, this.id, string2);
    }

    public OneResponse chown(int n, int n2) {
        return VirtualNetwork.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return VirtualNetwork.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return VirtualNetwork.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return VirtualNetwork.chmod(this.client, this.id, n);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return VirtualNetwork.update(this.client, this.id, string, bl);
    }

    public OneResponse rename(String string) {
        return VirtualNetwork.rename(this.client, this.id, string);
    }
}

