/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors;

import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;

public class VM
implements Comparable<VM> {
    protected Object envId;
    protected CloudMethodResourceDescription rd;
    protected COMPSsWorker node;
    protected CloudMethodWorker worker;
    protected long requestTime;
    protected long startTime;
    protected long creationTime;
    protected boolean toDelete;

    public VM(Object envId, CloudMethodResourceDescription description) {
        this.envId = envId;
        this.rd = description;
        this.requestTime = System.currentTimeMillis();
        this.startTime = 0L;
        this.creationTime = 0L;
        this.toDelete = false;
    }

    public void computeCreationTime() {
        this.creationTime = this.startTime - this.requestTime;
    }

    public String toString() {
        return "VM " + this.envId + " (ip = " + this.rd.getName() + ", request time = " + this.requestTime + ", start time = " + this.startTime + ", creation time = " + this.creationTime + ", image = " + this.rd.getImage().getName() + ", procs = " + this.rd.getProcessorCoreCount() + ", memory = " + this.rd.getMemoryPhysicalSize() + ", disk = " + this.rd.getStorageElemSize() + ", to delete = " + this.toDelete + ")";
    }

    public Object getEnvId() {
        return this.envId;
    }

    public String getName() {
        return this.rd.getName();
    }

    public CloudMethodResourceDescription getDescription() {
        return this.rd;
    }

    public COMPSsWorker getNode() {
        return this.node;
    }

    public void setWorker(CloudMethodWorker worker) {
        this.worker = worker;
    }

    public CloudMethodWorker getWorker() {
        return this.worker;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getImage() {
        return this.rd.getImage().getName();
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void setToDelete(boolean toDelete) {
        this.toDelete = toDelete;
    }

    @Override
    public int compareTo(VM vm) throws NullPointerException {
        if (vm == null) {
            throw new NullPointerException();
        }
        if (vm.getName().equals(this.getName())) {
            return 0;
        }
        long now = System.currentTimeMillis();
        int mod1 = (int)(now - this.getStartTime()) % 3600000;
        int mod2 = (int)(now - vm.getStartTime()) % 3600000;
        return mod2 - mod1;
    }
}

