/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.utils;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.VM;
import integratedtoolkit.connectors.utils.Operations;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.ResourceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class CreationThread
extends Thread {
    private static ResourceUser listener;
    private static Integer count;
    private static final Logger resourceLogger;
    private static final Logger runtimeLogger;
    private static final boolean debug;
    private final Operations operations;
    private final String name;
    private final String provider;
    private final ResourceCreationRequest rcr;
    private final VM reused;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreationThread(Operations operations, String name, String provider, ResourceCreationRequest rR, VM reused) {
        this.setName("creationThread");
        this.operations = operations;
        this.provider = provider;
        this.name = name;
        this.rcr = rR;
        this.reused = reused;
        Integer n = count;
        synchronized (n) {
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count + 1);
        }
    }

    public static int getCount() {
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        VM granted;
        boolean check = this.operations.getCheck();
        CloudMethodResourceDescription requested = this.rcr.getRequested();
        if (this.reused == null) {
            this.setName("Creation Thread " + this.name);
            try {
                granted = this.createResourceOnProvider(requested);
            }
            catch (Exception e) {
                this.notifyFailure();
                return;
            }
            if (debug) {
                runtimeLogger.debug((Object)("Resource " + granted.getName() + " with id  " + granted.getEnvId() + " has been created "));
            }
            resourceLogger.info((Object)("RESOURCE_GRANTED = [\n\tNAME = " + granted.getName() + "\n\tSTATUS = ID " + granted.getEnvId() + " CREATED\n]"));
        } else {
            granted = this.reused;
            if (debug) {
                runtimeLogger.debug((Object)("Resource " + granted.getName() + " with id  " + granted.getEnvId() + " has been reused "));
            }
            resourceLogger.info((Object)("RESOURCE_GRANTED = [\n\tNAME = " + this.reused.getName() + "\n\tSTATUS = ID " + granted.getEnvId() + " REUSED\n]"));
        }
        this.setName("creationThread " + granted.getName());
        CloudMethodWorker r = ResourceManager.getDynamicResource(granted.getName());
        if (r == null) {
            if (this.reused == null) {
                try {
                    if (debug) {
                        runtimeLogger.debug((Object)(" Preparing new worker resource " + granted.getName() + "."));
                    }
                    r = this.prepareNewResource(granted);
                    this.operations.vmReady(granted);
                }
                catch (Exception e) {
                    runtimeLogger.error((Object)"Error reusing resource.", (Throwable)e);
                    System.err.println("Error reusing resource.");
                    e.printStackTrace();
                    this.powerOff(granted);
                    this.notifyFailure();
                    return;
                }
            } else {
                r = new CloudMethodWorker(granted.getDescription(), granted.getNode(), granted.getDescription().getProcessorCoreCount());
                if (debug) {
                    runtimeLogger.debug((Object)(" Worker for new resource " + granted.getName() + " set."));
                }
            }
            granted.setWorker(r);
            ResourceManager.addCloudWorker(this.rcr, r);
        } else {
            ResourceManager.increasedCloudWorker(this.rcr, r, granted.getDescription());
        }
        Integer n = count;
        synchronized (n) {
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count - 1);
        }
    }

    public static void setTaskDispatcher(ResourceUser listener) {
        CreationThread.listener = listener;
    }

    private VM createResourceOnProvider(CloudMethodResourceDescription requested) throws Exception {
        VM granted;
        Object envID;
        try {
            envID = this.operations.poweron(this.name, requested);
        }
        catch (Exception e) {
            runtimeLogger.error((Object)("Error asking a new Resource to " + this.provider + "\n"), (Throwable)e);
            resourceLogger.error((Object)("ERROR_MSG = [\n\tError asking a new Resource to " + this.provider + "\n]"), (Throwable)e);
            throw e;
        }
        if (envID == null) {
            resourceLogger.info((Object)("INFO_MSG = [\n\t" + this.provider + " cannot provide this resource.\n]"));
            throw new Exception("Provider can not provide the vm");
        }
        try {
            granted = this.operations.waitCreation(envID, requested);
        }
        catch (ConnectorException e) {
            e.printStackTrace();
            resourceLogger.error((Object)("ERROR_MSG = [\n\tError waiting for a machine that should be provided by " + this.provider + "\n]"), (Throwable)e);
            try {
                this.operations.destroy(envID);
            }
            catch (ConnectorException ex) {
                resourceLogger.error((Object)"ERROR_MSG = [\n\tCannot poweroff the machine\n]");
            }
            throw new Exception("Error waiting for the vm");
        }
        if (granted == null) {
            throw new Exception("Granted description is null");
        }
        resourceLogger.debug((Object)"CONNECTOR_REQUEST = [");
        resourceLogger.debug((Object)("\tPROC = " + requested.getProcessorCoreCount() + " " + requested.getProcessorArchitecture() + " cores @ " + requested.getProcessorSpeed()));
        resourceLogger.debug((Object)("\tOS = " + requested.getOperatingSystemType()));
        resourceLogger.debug((Object)("\tMEM = " + requested.getMemoryVirtualSize() + "(" + requested.getMemoryPhysicalSize() + ")"));
        resourceLogger.debug((Object)"]");
        CloudMethodResourceDescription desc = granted.getDescription();
        resourceLogger.debug((Object)"CONNECTOR_GRANTED = [");
        resourceLogger.debug((Object)("\tPROC = " + desc.getProcessorCoreCount() + " " + desc.getProcessorArchitecture() + " cores @ " + desc.getProcessorSpeed()));
        resourceLogger.debug((Object)("\tOS = " + desc.getOperatingSystemType()));
        resourceLogger.debug((Object)("\tMEM = " + desc.getMemoryVirtualSize() + "(" + desc.getMemoryPhysicalSize() + ")"));
        resourceLogger.debug((Object)"]");
        return granted;
    }

    private CloudMethodWorker prepareNewResource(VM vm) throws Exception {
        CloudMethodWorker worker;
        CloudMethodResourceDescription granted = vm.getDescription();
        CloudImageDescription cid = granted.getImage();
        HashMap<String, String> workerProperties = cid.getProperties();
        String user = workerProperties.get("User");
        String password = workerProperties.get("Password");
        try {
            this.operations.configureAccess(granted.getName(), user, password);
        }
        catch (ConnectorException e) {
            runtimeLogger.error((Object)("Error configuring access to machine " + granted.getName()), (Throwable)e);
            resourceLogger.error((Object)("ERROR_MSG = [\n\tError configuring access to machine\n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]"), (Throwable)e);
            throw e;
        }
        try {
            this.operations.prepareMachine(granted.getName(), cid);
        }
        catch (ConnectorException e) {
            runtimeLogger.error((Object)("Exception preparing machine " + granted.getName()), (Throwable)e);
            resourceLogger.error((Object)("ERROR_MSG = [\n\tException preparing machine " + granted.getName() + "]"), (Throwable)e);
            throw e;
        }
        try {
            worker = new CloudMethodWorker(granted.getName(), granted, cid.getAdaptorsDescription(), workerProperties, (Integer)granted.getProcessorCoreCount());
        }
        catch (Exception e) {
            runtimeLogger.error((Object)("Error starting the worker application in machine " + granted.getName()), (Throwable)e);
            resourceLogger.error((Object)("ERROR_MSG = [\n\tError starting the worker application in machine\n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]"));
            throw new Exception("Could not turn on the VM", e);
        }
        try {
            worker.announceCreation();
        }
        catch (Exception e) {
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            worker.stop(false, sl);
            runtimeLogger.error((Object)("Error announcing the machine " + granted.getName() + ". Shutting down"), (Throwable)e);
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e2) {
                resourceLogger.error((Object)"ERROR: Exception raised on worker shutdown", (Throwable)e2);
            }
            runtimeLogger.error((Object)("Machine " + granted.getName() + " shut down because an error announcing destruction"));
            resourceLogger.error((Object)("ERROR_MSG = [\n\tError announcing the machine\n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]"), (Throwable)e);
            throw e;
        }
        if (this.operations.getTerminate()) {
            resourceLogger.info((Object)("INFO_MSG = [\n\tNew resource has been refused because integratedtoolkit has been stopped\n\tRESOURCE_NAME = " + granted.getName() + "\n]"));
            try {
                worker.announceDestruction();
            }
            catch (Exception e) {
                resourceLogger.error((Object)("ERROR_MSG = [\n\tError announcing VM destruction\n\tVM_NAME = " + granted.getName() + "\n]"), (Throwable)e);
            }
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            worker.stop(false, sl);
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e) {
                resourceLogger.error((Object)"ERROR: Exception raised on worker shutdown");
            }
            throw new Exception("Useless VM");
        }
        for (Map.Entry<String, String> disk : cid.getSharedDisks().entrySet()) {
            String diskName = disk.getKey();
            String mounpoint = disk.getValue();
            worker.addSharedDisk(diskName, mounpoint);
        }
        return worker;
    }

    private void powerOff(VM granted) {
        try {
            this.operations.poweroff(granted);
        }
        catch (Exception e) {
            resourceLogger.error((Object)"ERROR_MSG = [\n\tCannot poweroff the new resource\n]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure() {
        Integer n = count;
        synchronized (n) {
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count - 1);
        }
    }

    static {
        count = 0;
        resourceLogger = Logger.getLogger((String)"integratedtoolkit.Connectors");
        runtimeLogger = Logger.getLogger((String)"integratedtoolkit.Components.ResourceManager");
        debug = resourceLogger.isDebugEnabled();
    }
}

