/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.utils;

import integratedtoolkit.connectors.VM;
import integratedtoolkit.connectors.utils.Operations;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.ResourceManager;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class DeletionThread
extends Thread {
    private final Operations operations;
    private final CloudMethodWorker worker;
    private final CloudMethodResourceDescription reduction;
    private VM vm;
    private static Integer count = 0;
    private static final Logger resourcesLogger = Logger.getLogger((String)"integratedtoolkit.Connectors");
    private static final Logger runtimeLogger = Logger.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    private static final boolean debug = resourcesLogger.isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeletionThread(Operations connector, CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        this.setName("DeletionThread " + worker.getName());
        this.operations = connector;
        Integer n = count;
        synchronized (n) {
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count + 1);
        }
        this.worker = worker;
        this.reduction = reduction;
        this.vm = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeletionThread(Operations connector, VM vm) {
        this.setName("DeletionThread " + vm.getName());
        this.operations = connector;
        Integer n = count;
        synchronized (n) {
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count + 1);
        }
        this.worker = null;
        this.reduction = null;
        this.vm = vm;
    }

    public static int getCount() {
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.reduction != null) {
            Semaphore sem = ResourceManager.reduceCloudWorker(this.worker, this.reduction);
            try {
                if (sem != null) {
                    if (debug) {
                        runtimeLogger.debug((Object)("Waiting until all tasks finishes for resource " + this.worker.getName() + "..."));
                    }
                    sem.acquire();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (debug) {
                runtimeLogger.debug((Object)("All tasks finished for resource " + this.worker.getName() + ". Pausing worker..."));
            }
            this.vm = this.operations.pause(this.worker);
        }
        if (this.vm != null) {
            CloudMethodWorker worker = this.vm.getWorker();
            if (worker.shouldBeStopped()) {
                Semaphore sem = new Semaphore(0);
                ShutdownListener sl = new ShutdownListener(sem);
                runtimeLogger.info((Object)("Stopping worker " + worker.getName() + "..."));
                worker.stop(true, sl);
                sl.enable();
                try {
                    sem.acquire();
                }
                catch (Exception e) {
                    resourcesLogger.error((Object)"ERROR: Exception raised on worker shutdown");
                }
                if (debug) {
                    runtimeLogger.debug((Object)("Stopping worker " + worker.getName() + "..."));
                }
            } else if (debug) {
                runtimeLogger.debug((Object)("Worker " + worker.getName() + " should not be stopped."));
            }
            if (debug) {
                runtimeLogger.debug((Object)("Worker " + worker.getName() + " stopped. Powering of the VM"));
            }
            try {
                this.operations.poweroff(this.vm);
            }
            catch (Exception e) {
                resourcesLogger.error((Object)"Error powering off the resource", (Throwable)e);
            }
        }
        Integer n = count;
        synchronized (n) {
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count - 1);
            if (debug) {
                runtimeLogger.debug((Object)("Number of current VMs deletions decreased (" + count + ")."));
            }
        }
    }
}

