/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.Worker;
import java.util.HashMap;
import java.util.TreeMap;

public class MethodWorker
extends Worker<MethodResourceDescription> {
    private String name;
    protected final MethodResourceDescription available;

    public MethodWorker(String name, MethodResourceDescription description, COMPSsWorker worker, Integer maxTaskCount) {
        super(name, description, (COMPSsNode)worker, maxTaskCount);
        this.name = name;
        this.available = new MethodResourceDescription(description);
    }

    public MethodWorker(String name, MethodResourceDescription description, TreeMap<String, AdaptorDescription> adaptorsDesc, HashMap<String, String> properties, Integer maxTaskCount) throws Exception {
        super(name, description, adaptorsDesc, properties, maxTaskCount);
        this.name = name;
        if (description != null) {
            ((MethodResourceDescription)this.description).setSlots(maxTaskCount.intValue());
        }
        int coreCount = description.getProcessorCoreCount();
        String value = properties.get("LimitOfTasks");
        if (value != null && !value.isEmpty()) {
            int limitOfTasks = Integer.parseInt(value);
            if (limitOfTasks > coreCount) {
                properties.put("LimitOfTasks", Integer.toString(coreCount));
            }
        } else {
            properties.put("LimitOfTasks", Integer.toString(coreCount));
        }
        this.available = new MethodResourceDescription(description);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reserveResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.setProcessorCoreCount(this.available.getProcessorCoreCount() - consumption.getProcessorCoreCount());
            this.available.setMemoryPhysicalSize(this.available.getMemoryPhysicalSize() - consumption.getMemoryPhysicalSize());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.setProcessorCoreCount(this.available.getProcessorCoreCount() + consumption.getProcessorCoreCount());
            this.available.setMemoryPhysicalSize(this.available.getMemoryPhysicalSize() + consumption.getMemoryPhysicalSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            return this.available.getProcessorCoreCount() >= consumption.getProcessorCoreCount() && this.available.getMemoryPhysicalSize() >= consumption.getMemoryPhysicalSize();
        }
    }

    @Override
    public Integer fitCount(Implementation<?> impl) {
        if (impl.getType() == Implementation.Type.SERVICE) {
            return null;
        }
        MethodResourceDescription ctrs = (MethodResourceDescription)impl.getRequirements();
        return ((MethodResourceDescription)this.description).canHostSimultaneously(ctrs);
    }

    public Resource.Type getType() {
        return Resource.Type.WORKER;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<CPU>").append(((MethodResourceDescription)this.description).getProcessorCPUCount()).append("</CPU>").append("\n");
        sb.append(prefix).append("<Core>").append(((MethodResourceDescription)this.description).getProcessorCoreCount()).append("</Core>").append("\n");
        sb.append(prefix).append("<Memory>").append(((MethodResourceDescription)this.description).getMemoryPhysicalSize()).append("</Memory>").append("\n");
        sb.append(prefix).append("<Disk>").append(((MethodResourceDescription)this.description).getStorageElemSize()).append("</Disk>").append("\n");
        return sb.toString();
    }

    private Float getValue() {
        return ((MethodResourceDescription)this.description).value;
    }

    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case SERVICE: {
                return 1;
            }
            case WORKER: {
                MethodWorker w = (MethodWorker)t;
                if (((MethodResourceDescription)this.description).getValue() == null) {
                    if (w.getValue() == null) {
                        return w.getName().compareTo(this.getName());
                    }
                    return 1;
                }
                if (w.getValue() == null) {
                    return -1;
                }
                float dif = w.getValue().floatValue() - ((MethodResourceDescription)this.description).getValue().floatValue();
                if (dif > 0.0f) {
                    return -1;
                }
                if (dif < 0.0f) {
                    return 1;
                }
                return this.getName().compareTo(w.getName());
            }
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }

    @Override
    public boolean canRun(Implementation<?> implementation) {
        switch (implementation.getType()) {
            case METHOD: {
                MethodResourceDescription ctrs = (MethodResourceDescription)implementation.getRequirements();
                return ((MethodResourceDescription)this.description).contains(ctrs);
            }
        }
        return false;
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = WORKER").append("\n");
        sb.append(prefix).append("CPU = ").append(((MethodResourceDescription)this.description).getProcessorCPUCount()).append("\n");
        sb.append(prefix).append("MEMORY = ").append(((MethodResourceDescription)this.description).getMemoryPhysicalSize()).append("\n");
        return sb.toString();
    }
}

