/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.impl;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.impl.AccessProcessor;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.Task;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.ResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.log4j.Logger;

public class RuntimeMonitor
implements Runnable {
    private static String CURRENT_GRAPH = "current_graph.dot";
    private static String COMPLETE_GRAPH = "complete_graph.dot";
    private static String COMPLETE_GRAPH_TMP = "complete_graph.dot.tmp";
    private static BufferedWriter graph;
    private static final boolean monitorEnabled;
    private static final boolean drawGraph;
    private static final String monitorDirPath;
    private static final String ERROR_MONITOR_DIR = "ERROR: Cannot create monitor directory";
    private static final Logger logger;
    private TaskDispatcher TD;
    private AccessProcessor TP;
    private long sleepTime;
    private boolean keepRunning;
    private boolean running;
    private Thread monitor;
    String installDir;

    public static String getMonitorDirPath() {
        return monitorDirPath;
    }

    public RuntimeMonitor(AccessProcessor TP, TaskDispatcher TD, long sleepTime) {
        this.TD = TD;
        this.TP = TP;
        this.keepRunning = true;
        this.sleepTime = sleepTime;
        this.installDir = System.getenv().get("IT_HOME");
        this.monitor = new Thread(this);
        this.monitor.setName("Monitor Thread");
        this.monitor.start();
    }

    @Override
    public void run() {
        this.running = true;
        while (this.keepRunning) {
            try {
                this.printCurrentGraphState();
                this.getXMLTaskState();
                ResourceManager.printLoadInfo();
                ResourceManager.printResourcesState();
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {}
        }
        this.running = false;
    }

    public void shutdown() {
        this.keepRunning = false;
        try {
            while (this.running) {
                Thread.sleep(this.sleepTime);
            }
            this.printCurrentGraphState();
            this.getXMLTaskState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new File(monitorDirPath + "monitor.xml").delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commitGraph() {
        try {
            graph.close();
            AbstractInterruptibleChannel sourceChannel = null;
            AbstractInterruptibleChannel destChannel = null;
            try {
                sourceChannel = new FileInputStream(COMPLETE_GRAPH_TMP).getChannel();
                destChannel = new FileOutputStream(COMPLETE_GRAPH).getChannel();
                ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            }
            finally {
                sourceChannel.close();
                destChannel.close();
            }
            graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH, true));
            RuntimeMonitor.closeGraph(graph);
            graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_TMP, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void openGraph(BufferedWriter fw) throws IOException {
        fw.write("digraph {");
        fw.newLine();
        fw.write("ranksep=0.20;");
        fw.newLine();
        fw.write("node[height=0.75];");
        fw.newLine();
    }

    public static void addSynchroToGraph(int synchId) {
        try {
            graph.newLine();
            graph.write("Synchro" + synchId + "[label=\"sync\", shape=octagon, style=filled fillcolor=\"#ff0000\" fontcolor=\"#FFFFFF\"];");
        }
        catch (Exception e) {
            logger.error("Error adding task to graph file", e);
        }
    }

    public static void addTaskToGraph(Task task) {
        try {
            graph.newLine();
            graph.write(task.getDotDescription());
        }
        catch (Exception e) {
            logger.error("Error adding task to graph file", e);
        }
    }

    public static void addEdgeToGraph(String src, String tgt, String label) {
        try {
            graph.newLine();
            graph.write(src + " -> " + tgt + (label.isEmpty() ? ";" : "[ label=\"d" + label + "\" ];"));
        }
        catch (Exception e) {
            logger.error("Error adding edge to graph file", e);
        }
    }

    private static void closeGraph(BufferedWriter fw) throws IOException {
        fw.write("}");
        fw.close();
    }

    public static void removeTemporaryGraph() {
        new File(COMPLETE_GRAPH_TMP).delete();
    }

    private void printCurrentGraphState() throws IOException {
        String currentState = this.TP.getCurrentGraphState();
        BufferedWriter current = new BufferedWriter(new FileWriter(CURRENT_GRAPH));
        RuntimeMonitor.openGraph(current);
        current.write(currentState);
        RuntimeMonitor.closeGraph(current);
        current = null;
    }

    private void getXMLTaskState() throws IOException {
        BufferedWriter fw = new BufferedWriter(new FileWriter(monitorDirPath + "COMPSs_state.xml"));
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"" + this.installDir + "/xml/monitor/monitor.xsl\"?>\n" + "<COMPSsState>\n");
        sb.append(this.TP.getCurrentTaskState());
        sb.append(this.TD.getCurrentMonitoringData());
        sb.append("</COMPSsState>");
        fw.write(sb.toString());
        fw.close();
        fw = null;
    }

    public static boolean isEnabled() {
        return monitorEnabled;
    }

    static {
        monitorEnabled = System.getProperty("it.monitor") != null && !System.getProperty("it.monitor").equals("0");
        drawGraph = System.getProperty("it.graph") != null && System.getProperty("it.graph").equals("true");
        logger = Logger.getLogger("integratedtoolkit.Components");
        if (monitorEnabled || drawGraph) {
            monitorDirPath = Comm.appHost.getAppLogDirPath() + "monitor" + File.separator;
            if (!new File(monitorDirPath).mkdir()) {
                ErrorManager.error(ERROR_MONITOR_DIR);
            }
            CURRENT_GRAPH = monitorDirPath + "current_graph.dot";
            COMPLETE_GRAPH = monitorDirPath + "complete_graph.dot";
            COMPLETE_GRAPH_TMP = monitorDirPath + "complete_graph.dot.tmp";
            if (drawGraph) {
                try {
                    graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH));
                    RuntimeMonitor.openGraph(graph);
                    RuntimeMonitor.closeGraph(graph);
                    graph = null;
                }
                catch (IOException ioe) {
                    logger.error("Error generating graph file", ioe);
                }
                try {
                    graph = new BufferedWriter(new FileWriter(COMPLETE_GRAPH_TMP));
                    RuntimeMonitor.openGraph(graph);
                }
                catch (IOException ioe) {
                    logger.error("Error generating graph file", ioe);
                }
            }
        } else {
            monitorDirPath = null;
        }
    }
}

