/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.loader.total;

import integratedtoolkit.loader.LoaderUtils;
import integratedtoolkit.loader.total.ArrayAccessWatcher;
import integratedtoolkit.types.annotations.Method;
import integratedtoolkit.types.annotations.Parameter;
import integratedtoolkit.types.annotations.Service;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.apache.log4j.Logger;

public class ITAppEditor
extends ExprEditor {
    private java.lang.reflect.Method[] remoteMethods;
    private CtMethod[] instrCandidates;
    private String itApiVar;
    private String itExeVar;
    private String itSRVar;
    private String itORVar;
    private String itAppIdVar;
    private CtClass appClass;
    private static final String aawClassName = ArrayAccessWatcher.class.getCanonicalName();
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Loader");
    private static final boolean debug = logger.isDebugEnabled();

    public ITAppEditor(java.lang.reflect.Method[] remoteMethods, CtMethod[] instrCandidates, String itApiVar, String itExeVar, String itSRVar, String itORVar, String itAppIdVar, CtClass appClass) {
        this.remoteMethods = remoteMethods;
        this.instrCandidates = instrCandidates;
        this.itApiVar = itApiVar;
        this.itExeVar = itExeVar;
        this.itSRVar = itSRVar;
        this.itORVar = itORVar;
        this.itAppIdVar = itAppIdVar;
        this.appClass = appClass;
    }

    @Override
    public void edit(NewExpr ne) throws CannotCompileException {
        String fullName = ne.getClassName();
        boolean isInternal = fullName.startsWith("integratedtoolkit.");
        boolean isIO = fullName.startsWith("java.io.");
        if (!isInternal) {
            StringBuilder modifiedExpr = new StringBuilder();
            StringBuilder callPars = new StringBuilder();
            StringBuilder toSerialize = new StringBuilder();
            try {
                CtClass[] paramTypes = ne.getConstructor().getParameterTypes();
                if (paramTypes.length > 0) {
                    int i = 1;
                    for (CtClass parType : paramTypes) {
                        if (i > 1) {
                            callPars.append(',');
                        }
                        String parId = "$" + i++;
                        if (parType.isPrimitive()) {
                            callPars.append(parId);
                            continue;
                        }
                        if (debug) {
                            logger.debug("Parameter " + (i - 1) + " of constructor " + ne.getConstructor() + " is an object, adding access");
                        }
                        String internalObject = this.itORVar + ".getInternalObject(" + parId + ')';
                        modifiedExpr.insert(0, this.itORVar + ".newObjectAccess(" + parId + ");");
                        callPars.append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                        toSerialize.append(this.itORVar).append(".serializeLocally(").append(parId).append(");");
                    }
                }
            }
            catch (NotFoundException e) {
                throw new CannotCompileException(e);
            }
            if (isIO) {
                String className = fullName.substring(8);
                if (debug) {
                    logger.debug("Inspecting the creation of an object of class " + className);
                }
                if (className.equals("FileInputStream")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newFileInputStream(" + callPars + ");");
                } else if (className.equals("FileOutputStream")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newFileOutputStream(" + callPars + ");");
                } else if (className.equals("InputStreamReader")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newInputStreamReader(" + callPars + ");");
                } else if (className.equals("BufferedReader")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newBufferedReader(" + callPars + ");");
                } else if (className.equals("FileWriter")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newFileWriter(" + callPars + ");");
                } else if (className.equals("PrintWriter")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newPrintWriter(" + callPars + ");");
                } else if (className.equals("FileReader")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newFileReader(" + callPars + ");");
                } else if (className.equals("OutputStreamWriter")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newOutputStreamWriter(" + callPars + ");");
                } else if (className.equals("BufferedWriter")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newBufferedWriter(" + callPars + ");");
                } else if (className.equals("PrintStream")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newPrintStream(" + callPars + ");");
                } else if (className.equals("RandomAccessFile")) {
                    modifiedExpr.append("$_ = " + this.itSRVar + ".newRandomAccessFile(" + callPars + ");");
                } else {
                    String internalObject = this.itORVar + ".getInternalObject($1)";
                    String par1 = internalObject + " == null ? (Object)$1 : " + internalObject;
                    modifiedExpr.append("$_ = $proceed(" + callPars + "); " + "if ($_ instanceof java.io.FilterInputStream || $_ instanceof java.io.FilterOutputStream) {" + this.itSRVar + ".newFilterStream(" + par1 + ", (Object)$_); }");
                }
            } else {
                modifiedExpr.append("$_ = $proceed(").append((CharSequence)callPars).append(");");
                modifiedExpr.append((CharSequence)toSerialize);
            }
            if (debug) {
                logger.debug("Replacing regular constructor call of class " + fullName + " by " + modifiedExpr.toString());
            }
            ne.replace(modifiedExpr.toString());
        }
    }

    @Override
    public void edit(MethodCall mc) throws CannotCompileException {
        java.lang.reflect.Method declaredMethod = null;
        CtMethod calledMethod = null;
        try {
            calledMethod = mc.getMethod();
            declaredMethod = LoaderUtils.checkRemote(calledMethod, this.remoteMethods);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        if (declaredMethod != null) {
            String methodName = mc.getMethodName();
            if (debug) {
                logger.debug("Found call to remote method " + methodName);
            }
            Class<?> retType = declaredMethod.getReturnType();
            boolean isVoid = retType.equals(Void.TYPE);
            boolean isStatic = Modifier.isStatic(calledMethod.getModifiers());
            boolean isMethod = declaredMethod.isAnnotationPresent(Method.class);
            Class<?>[] paramTypes = declaredMethod.getParameterTypes();
            int numParams = paramTypes.length;
            if (!isStatic) {
                ++numParams;
            }
            if (!isVoid) {
                ++numParams;
            }
            String methodClass = mc.getClassName();
            Annotation[][] paramAnnot = declaredMethod.getParameterAnnotations();
            StringBuilder executeTask = new StringBuilder();
            executeTask.append(this.itExeVar).append(".executeTask(");
            executeTask.append(this.itAppIdVar).append(',');
            if (isMethod) {
                Method methodAnnot = declaredMethod.getAnnotation(Method.class);
                executeTask.append("\"").append(methodClass).append("\"").append(',');
                executeTask.append("\"").append(methodName).append("\"").append(',');
                executeTask.append(methodAnnot.priority()).append(',');
            } else {
                Service serviceAnnot = declaredMethod.getAnnotation(Service.class);
                executeTask.append("\"").append(serviceAnnot.namespace()).append("\"").append(',');
                executeTask.append("\"").append(serviceAnnot.name()).append("\"").append(',');
                executeTask.append("\"").append(serviceAnnot.port()).append("\"").append(',');
                executeTask.append("\"").append(methodName).append("\"").append(',');
                executeTask.append(serviceAnnot.priority()).append(',');
            }
            executeTask.append(!isStatic).append(',');
            executeTask.append(numParams);
            if (numParams == 0) {
                executeTask.append(",null);");
            } else {
                executeTask.append(",new Object[]{");
                for (int i = 0; i < paramAnnot.length; ++i) {
                    String type = null;
                    String direction = null;
                    Class<?> formalType = paramTypes[i];
                    Parameter.Type annotType = ((Parameter)paramAnnot[i][0]).type();
                    if (annotType.equals((Object)Parameter.Type.FILE)) {
                        type = "ITExecution.ParamType.FILE_T";
                        executeTask.append('$').append(i + 1).append(',');
                        executeTask.insert(0, this.itSRVar + ".addTaskFile($" + (i + 1) + ");");
                    } else if (annotType.equals((Object)Parameter.Type.STRING)) {
                        type = "ITExecution.ParamType.STRING_T";
                        executeTask.append('$').append(i + 1).append(',');
                    } else if (formalType.isPrimitive()) {
                        if (formalType.equals(Boolean.TYPE)) {
                            type = "ITExecution.ParamType.BOOLEAN_T";
                            executeTask.append("new Boolean(").append("$").append(i + 1).append("),");
                        } else if (formalType.equals(Character.TYPE)) {
                            type = "ITExecution.ParamType.CHAR_T";
                            executeTask.append("new Character(").append("$").append(i + 1).append("),");
                        } else if (formalType.equals(Byte.TYPE)) {
                            type = "ITExecution.ParamType.BYTE_T";
                            executeTask.append("new Byte(").append("$").append(i + 1).append("),");
                        } else if (formalType.equals(Short.TYPE)) {
                            type = "ITExecution.ParamType.SHORT_T";
                            executeTask.append("new Short(").append("$").append(i + 1).append("),");
                        } else if (formalType.equals(Integer.TYPE)) {
                            type = "ITExecution.ParamType.INT_T";
                            executeTask.append("new Integer(").append("$").append(i + 1).append("),");
                        } else if (formalType.equals(Long.TYPE)) {
                            type = "ITExecution.ParamType.LONG_T";
                            executeTask.append("new Long(").append("$").append(i + 1).append("),");
                        } else if (formalType.equals(Float.TYPE)) {
                            type = "ITExecution.ParamType.FLOAT_T";
                            executeTask.append("new Float(").append("$").append(i + 1).append("),");
                        } else if (formalType.equals(Double.TYPE)) {
                            type = "ITExecution.ParamType.DOUBLE_T";
                            executeTask.append("new Double(").append("$").append(i + 1).append("),");
                        }
                    } else {
                        type = "ITExecution.ParamType.OBJECT_T";
                        executeTask.append('$').append(i + 1).append(',');
                    }
                    switch (((Parameter)paramAnnot[i][0]).direction()) {
                        case IN: {
                            direction = "ITExecution.ParamDirection.IN";
                            break;
                        }
                        case OUT: {
                            direction = "ITExecution.ParamDirection.OUT";
                            break;
                        }
                        case INOUT: {
                            direction = "ITExecution.ParamDirection.INOUT";
                            break;
                        }
                        default: {
                            direction = "ITExecution.ParamDirection.IN";
                        }
                    }
                    executeTask.append(type).append(",");
                    executeTask.append(direction);
                    if (i >= paramAnnot.length - 1) continue;
                    executeTask.append(",");
                }
                if (!isStatic) {
                    if ((isVoid ? numParams : numParams - 1) > 1) {
                        executeTask.append(',');
                    }
                    executeTask.append("$0,").append("ITExecution.ParamType.OBJECT_T");
                    if (isMethod) {
                        Method methodAnnot = declaredMethod.getAnnotation(Method.class);
                        if (methodAnnot.isModifier()) {
                            executeTask.append(',').append("ITExecution.ParamDirection.INOUT");
                        } else {
                            executeTask.append(',').append("ITExecution.ParamDirection.IN");
                        }
                    } else {
                        executeTask.append(',').append("ITExecution.ParamDirection.INOUT");
                    }
                }
                StringBuilder afterExecute = new StringBuilder("");
                if (!isVoid) {
                    if (numParams > 1) {
                        executeTask.append(',');
                    }
                    String typeName = retType.getName();
                    if (retType.isPrimitive()) {
                        String converterMethod;
                        String cast;
                        String tempRetVar = "ret" + System.nanoTime();
                        executeTask.append(tempRetVar).append(',').append("ITExecution.ParamType.OBJECT_T").append(',').append("ITExecution.ParamDirection.OUT");
                        String retValueCreation = "Object " + tempRetVar + " = ";
                        if (typeName.equals(Boolean.TYPE.getName())) {
                            retValueCreation = retValueCreation + "new Boolean(false);";
                            cast = "(Boolean)";
                            converterMethod = "booleanValue()";
                        } else if (typeName.equals(Character.TYPE.getName())) {
                            retValueCreation = retValueCreation + "new Character(Character.MIN_VALUE);";
                            cast = "(Character)";
                            converterMethod = "charValue()";
                        } else if (typeName.equals(Byte.TYPE.getName())) {
                            retValueCreation = retValueCreation + "new Byte(Byte.MIN_VALUE);";
                            cast = "(Byte)";
                            converterMethod = "byteValue()";
                        } else if (typeName.equals(Short.TYPE.getName())) {
                            retValueCreation = retValueCreation + "new Short(Short.MIN_VALUE);";
                            cast = "(Short)";
                            converterMethod = "shortValue()";
                        } else if (typeName.equals(Integer.TYPE.getName())) {
                            retValueCreation = retValueCreation + "new Integer(Integer.MIN_VALUE);";
                            cast = "(Integer)";
                            converterMethod = "intValue()";
                        } else if (typeName.equals(Long.TYPE.getName())) {
                            retValueCreation = retValueCreation + "new Long(Long.MIN_VALUE);";
                            cast = "(Long)";
                            converterMethod = "longValue()";
                        } else if (typeName.equals(Float.TYPE.getName())) {
                            retValueCreation = retValueCreation + "new Float(Float.MIN_VALUE);";
                            cast = "(Float)";
                            converterMethod = "floatValue()";
                        } else {
                            retValueCreation = retValueCreation + "new Double(Double.MIN_VALUE);";
                            cast = "(Double)";
                            converterMethod = "doubleValue()";
                        }
                        executeTask.insert(0, retValueCreation);
                        afterExecute.append(this.itORVar).append(".newObjectAccess(").append(tempRetVar).append(");");
                        afterExecute.append("$_ = (").append(cast).append(this.itORVar).append(".getInternalObject(").append(tempRetVar).append(")).").append(converterMethod).append(";");
                    } else if (retType.isArray()) {
                        Class<?> compType = retType.getComponentType();
                        int numDim = typeName.lastIndexOf(91);
                        String dims = "[0]";
                        while (numDim-- > 0) {
                            dims = dims + "[]";
                        }
                        while (compType.getComponentType() != null) {
                            compType = compType.getComponentType();
                        }
                        String compTypeName = compType.getName();
                        executeTask.insert(0, "$_ = new " + compTypeName + dims + ';');
                        executeTask.append("$_,").append("ITExecution.ParamType.OBJECT_T");
                        executeTask.append(',').append("ITExecution.ParamDirection.OUT");
                    } else {
                        if (typeName.equals(Boolean.class.getName())) {
                            executeTask.insert(0, "$_ = new Boolean(false);");
                        } else if (typeName.equals(Character.class.getName())) {
                            executeTask.insert(0, "$_ = new Character(Character.MIN_VALUE);");
                        } else if (typeName.equals(Byte.class.getName())) {
                            executeTask.insert(0, "$_ = new Byte(Byte.MIN_VALUE);");
                        } else if (typeName.equals(Short.class.getName())) {
                            executeTask.insert(0, "$_ = new Short(Short.MIN_VALUE);");
                        } else if (typeName.equals(Integer.class.getName())) {
                            executeTask.insert(0, "$_ = new Integer(Integer.MIN_VALUE);");
                        } else if (typeName.equals(Long.class.getName())) {
                            executeTask.insert(0, "$_ = new Long(Long.MIN_VALUE);");
                        } else if (typeName.equals(Float.class.getName())) {
                            executeTask.insert(0, "$_ = new Float(Float.MIN_VALUE);");
                        } else if (typeName.equals(Double.class.getName())) {
                            executeTask.insert(0, "$_ = new Double(Double.MIN_VALUE);");
                        } else {
                            executeTask.insert(0, "$_ = new " + typeName + "();");
                        }
                        executeTask.append("$_,").append("ITExecution.ParamType.OBJECT_T");
                        executeTask.append(',').append("ITExecution.ParamDirection.OUT");
                    }
                }
                executeTask.append("});");
                executeTask.append((CharSequence)afterExecute);
            }
            if (debug) {
                logger.debug("Replacing local method call by: " + executeTask.toString());
            }
            mc.replace(executeTask.toString());
        } else if (LoaderUtils.isStreamClose(mc)) {
            if (debug) {
                logger.debug("Replacing close on a stream of class " + mc.getClassName());
            }
            mc.replace("$_ = $proceed($$); " + this.itSRVar + ".streamClosed($0);");
        } else if (LoaderUtils.isFileDelete(mc)) {
            mc.replace("$_ = " + this.itApiVar + ".deleteFile($0.getCanonicalPath());");
        } else {
            boolean isBlackBox;
            boolean bl = isBlackBox = !LoaderUtils.contains(this.instrCandidates, calledMethod);
            if (isBlackBox) {
                if (debug) {
                    logger.debug("Inspecting method call to black-box method " + mc.getMethodName() + ", looking for objects");
                }
                StringBuilder modifiedCall = new StringBuilder();
                StringBuilder toSerialize = new StringBuilder();
                boolean isArrayWatch = calledMethod.getDeclaringClass().getName().equals(aawClassName);
                modifiedCall.append(this.itORVar).append(".newObjectAccess($0);");
                toSerialize.append(this.itORVar).append(".serializeLocally($0);");
                String redirectedCallPars = null;
                try {
                    CtClass[] paramTypes = mc.getMethod().getParameterTypes();
                    if (paramTypes.length > 0) {
                        int i = 1;
                        StringBuilder aux1 = new StringBuilder("new Object[] {");
                        for (CtClass parType : paramTypes) {
                            if (i > 1) {
                                aux1.append(',');
                            }
                            String parId = "$" + i;
                            if (parType.isPrimitive()) {
                                if (parType.equals(CtClass.booleanType)) {
                                    aux1.append("new Boolean(").append(parId).append(')');
                                } else if (parType.equals(CtClass.charType)) {
                                    aux1.append("new Character(").append(parId).append(')');
                                } else if (parType.equals(CtClass.byteType)) {
                                    aux1.append("new Byte(").append(parId).append(')');
                                } else if (parType.equals(CtClass.shortType)) {
                                    aux1.append("new Short(").append(parId).append(')');
                                } else if (parType.equals(CtClass.intType)) {
                                    aux1.append("new Integer(").append(parId).append(')');
                                } else if (parType.equals(CtClass.longType)) {
                                    aux1.append("new Long(").append(parId).append(')');
                                } else if (parType.equals(CtClass.floatType)) {
                                    aux1.append("new Float(").append(parId).append(')');
                                } else {
                                    aux1.append("new Double(").append(parId).append(')');
                                }
                            } else if (parType.getName().equals(String.class.getName())) {
                                if (debug) {
                                    logger.debug("Parameter " + i + " of black-box method " + mc.getMethodName() + " is an String, adding File/object access");
                                }
                                if (isArrayWatch && i == 3) {
                                    aux1.append(parId);
                                } else {
                                    String internalObject;
                                    String calledClass = mc.getClassName();
                                    if (calledClass.equals(PrintStream.class.getName()) || calledClass.equals(StringBuilder.class.getName())) {
                                        internalObject = this.itORVar + ".getInternalObject(" + parId + ')';
                                        modifiedCall.insert(0, this.itORVar + ".newObjectAccess(" + parId + ");");
                                        aux1.append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                                        toSerialize.append(this.itORVar).append(".serializeLocally(").append(parId).append(");");
                                    } else {
                                        internalObject = this.itORVar + ".getInternalObject(" + parId + ')';
                                        String taskFile = this.itSRVar + ".isTaskFile(" + parId + ")";
                                        String apiOpenFile = this.itApiVar + ".openFile(" + parId + ", integratedtoolkit.api.IntegratedToolkit.OpenMode.APPEND)";
                                        modifiedCall.insert(0, this.itORVar + ".newObjectAccess(" + parId + ");");
                                        aux1.append(taskFile).append(" ? ").append(apiOpenFile).append(" : ").append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                                        toSerialize.append(this.itORVar).append(".serializeLocally(").append(parId).append(");");
                                    }
                                }
                            } else {
                                if (debug) {
                                    logger.debug("Parameter " + i + " of black-box method " + mc.getMethodName() + " is an object, adding access");
                                }
                                if (isArrayWatch && i == 3) {
                                    aux1.append(parId);
                                } else {
                                    String internalObject = this.itORVar + ".getInternalObject(" + parId + ')';
                                    modifiedCall.insert(0, this.itORVar + ".newObjectAccess(" + parId + ");");
                                    aux1.append(internalObject).append(" == null ? ").append(parId).append(" : ").append("(" + parType.getName() + ")").append(internalObject);
                                    toSerialize.append(this.itORVar).append(".serializeLocally(").append(parId).append(");");
                                }
                            }
                            ++i;
                        }
                        aux1.append('}');
                        redirectedCallPars = aux1.toString();
                    }
                }
                catch (NotFoundException e) {
                    throw new CannotCompileException(e);
                }
                String internalObject = this.itORVar + ".getInternalObject($0)";
                modifiedCall.append("if (").append(internalObject).append(" != null) {").append("$_ = ($r)LoaderUtils.runMethodOnObject(").append(internalObject).append(",$class,\"").append(mc.getMethodName()).append("\",").append(redirectedCallPars).append(",$sig);").append("}else { $_ = ($r)LoaderUtils.runMethodOnObject($0,$class,\"").append(mc.getMethodName()).append("\",").append(redirectedCallPars).append(",$sig); }");
                modifiedCall.append((CharSequence)toSerialize);
                if (debug) {
                    logger.debug("Replacing regular method call by " + modifiedCall.toString());
                }
                mc.replace(modifiedCall.toString());
            }
        }
    }

    @Override
    public void edit(FieldAccess fa) throws CannotCompileException {
        CtField field = null;
        try {
            field = fa.getField();
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        String fieldName = field.getName();
        if (debug) {
            logger.debug("Keeping track of access to field " + fieldName + " of class " + field.getDeclaringClass().getName());
        }
        boolean isWriter = fa.isWriter();
        StringBuilder toInclude = new StringBuilder();
        toInclude.append(this.itORVar).append(".newObjectAccess($0,").append(isWriter).append(");");
        String internalObject = this.itORVar + ".getInternalObject($0)";
        String objectClass = fa.getClassName();
        toInclude.append("if (").append(internalObject).append(" != null) {");
        if (isWriter) {
            toInclude.append("((").append(objectClass).append(')').append(internalObject).append(").").append(fieldName).append(" = $1;");
            toInclude.append("} else { $_ = $proceed($$); }");
            toInclude.append(this.itORVar).append(".serializeLocally($0);");
        } else {
            toInclude.append("$_ = ((").append(objectClass).append(')').append(internalObject).append(").").append(fieldName).append(';');
            toInclude.append("} else { $_ = $proceed($$); }");
        }
        fa.replace(toInclude.toString());
        if (debug) {
            logger.debug("Replaced regular field access by " + toInclude.toString());
        }
    }
}

