/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types;

import integratedtoolkit.connectors.Connector;
import integratedtoolkit.connectors.Cost;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.CloudImageManager;
import integratedtoolkit.util.CloudTypeManager;
import integratedtoolkit.util.CoreManager;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;

public class CloudProvider {
    public String name;
    private Connector connector;
    private Cost cost;
    private CloudImageManager imgManager;
    private CloudTypeManager typeManager;
    private int currentVMCount;
    private Integer limitOfVMs;
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.TaskScheduler");

    public CloudProvider(String connectorPath, Integer limitOfVMs, HashMap<String, String> connectorProperties, String name) throws Exception {
        this.name = name;
        this.limitOfVMs = limitOfVMs;
        this.imgManager = new CloudImageManager();
        Class<?> conClass = Class.forName(connectorPath);
        Constructor<?> ctor = conClass.getDeclaredConstructors()[0];
        Object conector = ctor.newInstance(name, connectorProperties);
        this.connector = (Connector)conector;
        this.cost = (Cost)conector;
        this.typeManager = new CloudTypeManager();
        this.currentVMCount = 0;
    }

    public void addCloudImage(CloudImageDescription cid) {
        this.imgManager.add(cid);
    }

    public void addInstanceType(CloudMethodResourceDescription rd) {
        this.typeManager.add(rd);
    }

    public void newCoreElementsDetected(LinkedList<Integer> newCores) {
        this.typeManager.newCoreElementsDetected(newCores);
    }

    public String getName() {
        return this.name;
    }

    public float getCurrentCostPerHour() {
        return this.cost.currentCostPerHour().floatValue();
    }

    public float getTotalCost() {
        return this.cost.getTotalCost().floatValue();
    }

    public Set<String> getAllImageNames() {
        return this.imgManager.getAllImageNames();
    }

    public Set<String> getAllInstanceTypeNames() {
        return this.typeManager.getAllInstanceTypeNames();
    }

    public int[][] getSimultaneousImpls(String type) {
        return this.typeManager.getSimultaneousImpls(type);
    }

    public long getNextCreationTime() throws Exception {
        return this.connector.getNextCreationTime();
    }

    public long getTimeSlot() throws Exception {
        return this.connector.getTimeSlot();
    }

    public HashMap<CloudMethodResourceDescription, Integer> getVMComposition(String name) {
        return this.typeManager.getComposition(name);
    }

    public void stopReached() {
        this.connector.stopReached();
    }

    public boolean turnON(ResourceCreationRequest rcr) {
        ++this.currentVMCount;
        return this.connector.turnON("compss" + UUID.randomUUID().toString(), rcr);
    }

    public void createdVM(String resourceName, CloudMethodResourceDescription rd) {
        this.typeManager.createdVM(resourceName, rd.getType());
    }

    public void refusedWorker(CloudMethodResourceDescription rd) {
        --this.currentVMCount;
    }

    public void turnOff(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        this.typeManager.reduceVM(this.name, reduction.getType());
        this.connector.terminate(worker, reduction);
        --this.currentVMCount;
    }

    public int getCurrentVMCount() {
        return this.currentVMCount;
    }

    public CloudMethodResourceDescription getBestIncrease(Integer amount, MethodResourceDescription constraints, boolean contained) {
        CloudMethodResourceDescription result = null;
        if (this.limitOfVMs != null && this.currentVMCount >= this.limitOfVMs) {
            return result;
        }
        LinkedList<CloudMethodResourceDescription> instances = this.typeManager.getCompatibleTypes(constraints);
        if (instances.isEmpty()) {
            return result;
        }
        result = contained ? this.selectContainedInstance(instances, constraints, amount) : this.selectContainingInstance(instances, constraints, amount);
        if (result != null) {
            LinkedList<CloudImageDescription> images = this.imgManager.getCompatibleImages(constraints);
            if (images.isEmpty()) {
                return null;
            }
            result.setImage(images.get(0));
            result.setProviderName(images.get(0).getProviderName());
            result.setValue(this.cost.getMachineCostPerHour(result).floatValue());
        }
        return result;
    }

    private CloudMethodResourceDescription selectContainingInstance(LinkedList<CloudMethodResourceDescription> instances, MethodResourceDescription constraints, int amount) {
        CloudMethodResourceDescription result = null;
        float bestDistance = -2.1474836E9f;
        for (CloudMethodResourceDescription rd : instances) {
            int slots = rd.canHostSimultaneously(constraints);
            float distance = slots - amount;
            logger.debug("Can host: slots = " + slots + " amount = " + amount + " distance = " + distance + " bestDistance = " + bestDistance);
            if (distance > 0.0f) continue;
            if (distance > bestDistance) {
                result = rd;
                bestDistance = distance;
                continue;
            }
            if (distance != bestDistance || result == null || result.getValue() == null || rd.getValue() == null || !(result.getValue().floatValue() > rd.getValue().floatValue())) continue;
            result = rd;
            bestDistance = distance;
        }
        if (result == null) {
            return null;
        }
        return new CloudMethodResourceDescription(result);
    }

    private CloudMethodResourceDescription selectContainedInstance(LinkedList<CloudMethodResourceDescription> instances, MethodResourceDescription constraints, int amount) {
        CloudMethodResourceDescription result = null;
        float bestDistance = 2.1474836E9f;
        for (CloudMethodResourceDescription rd : instances) {
            int slots = rd.canHostSimultaneously(constraints);
            float distance = slots - amount;
            logger.debug("Can host: slots = " + slots + " amount = " + amount + " distance = " + distance + " bestDistance = " + bestDistance);
            if (distance < 0.0f) continue;
            if (distance < bestDistance) {
                result = rd;
                bestDistance = distance;
                continue;
            }
            if (result == null || distance != bestDistance || result.getValue() == null || rd.getValue() == null || !(result.getValue().floatValue() > rd.getValue().floatValue())) continue;
            result = rd;
            bestDistance = distance;
        }
        if (result == null) {
            return null;
        }
        return new CloudMethodResourceDescription(result);
    }

    public HashMap<String, Object[]> getPossibleReductions(CloudMethodWorker res, float[] recommendedSlots) {
        HashMap<String, Object[]> reductions = new HashMap<String, Object[]>();
        HashMap<String, Object[]> types = this.typeManager.getPossibleReductions(res.getName());
        for (Map.Entry<String, Object[]> type : types.entrySet()) {
            String typeName = type.getKey();
            Object[] description = type.getValue();
            int[] reducedSlots = (int[])description[0];
            float[] values = new float[3];
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (!res.canRun(coreId)) continue;
                if (recommendedSlots[coreId] < 1.0f && reducedSlots[coreId] > 0) {
                    values[0] = values[0] + 1.0f;
                    values[1] = values[1] + (float)reducedSlots[coreId];
                    continue;
                }
                float dif = (float)reducedSlots[coreId] - recommendedSlots[coreId];
                if (dif < 0.0f) {
                    values[2] = values[2] + (float)reducedSlots[coreId];
                    continue;
                }
                values[2] = values[2] + recommendedSlots[coreId];
                values[1] = values[1] + dif;
            }
            description[0] = values;
            reductions.put(typeName, description);
        }
        return reductions;
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("PROVIDER = [").append("\n");
        sb.append(prefix).append("\t").append("NAME = ").append(this.name).append("\n");
        sb.append(prefix).append("\t").append("CURRENT_VM = ").append(this.currentVMCount).append("\n");
        sb.append(prefix).append("\t").append("LIMIT_VM = ").append(this.limitOfVMs).append("\n");
        sb.append(this.imgManager.getCurrentState(prefix + "\t"));
        sb.append(this.typeManager.getCurrentState(prefix + "\t"));
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }

    public CloudImageManager getCloudImageManager() {
        return this.imgManager;
    }

    public CloudTypeManager getCloudTypeManager() {
        return this.typeManager;
    }

    public void terminateAll() {
        this.currentVMCount = 0;
        this.typeManager.clearAll();
        this.connector.terminateAll();
    }
}

