/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.request.ap;

import integratedtoolkit.components.impl.DataInfoProvider;
import integratedtoolkit.components.impl.TaskAnalyser;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.data.FileInfo;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.request.ap.APRequest;
import java.io.File;

public class DeleteFileRequest
extends APRequest {
    private final DataLocation loc;

    public DeleteFileRequest(DataLocation loc) {
        this.loc = loc;
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    @Override
    public void process(TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        FileInfo fileInfo = dip.deleteData(this.loc);
        if (fileInfo == null) {
            File f = new File(this.loc.getPath());
            f.delete();
        } else if (!fileInfo.isToDelete()) {
            ta.deleteFile(fileInfo);
        }
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.DELETE_FILE;
    }
}

