/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.request.td;

import integratedtoolkit.components.impl.JobManager;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.MethodImplementation;
import integratedtoolkit.types.request.td.TDRequest;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ResourceManager;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class CERegistration
extends TDRequest {
    private Semaphore sem;
    private final String signature;
    private final String declaringClass;
    private final MethodResourceDescription mrd;

    public CERegistration(String signature, String declaringClass, MethodResourceDescription mrd, Semaphore sem) {
        this.signature = signature;
        this.declaringClass = declaringClass;
        this.mrd = mrd;
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public void setSemaphore(Semaphore sem) {
        this.sem = sem;
    }

    @Override
    public void process(TaskScheduler ts, JobManager jm) {
        int coreId = CoreManager.getCoreId(new String[]{this.signature});
        int implementationId = 0;
        MethodImplementation me = new MethodImplementation(this.declaringClass, coreId, implementationId, this.mrd);
        Implementation[] impls = new Implementation[]{me};
        CoreManager.registerImplementations(coreId, impls);
        LinkedList<Integer> newCores = new LinkedList<Integer>();
        newCores.add(coreId);
        ResourceManager.coreElementUpdates(newCores);
        ts.resizeDataStructures();
        logger.debug("Data structures resized and CE-resources links updated");
        this.sem.release();
    }

    @Override
    public TDRequest.TDRequestType getRequestType() {
        return TDRequest.TDRequestType.UPDATE_LOCAL_CEI;
    }
}

