/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.request.td;

import integratedtoolkit.components.impl.JobManager;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.types.request.td.TDRequest;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.ResourceManager;
import java.util.concurrent.Semaphore;

public class MonitoringDataRequest
extends TDRequest {
    private Semaphore sem;
    private String response;

    public MonitoringDataRequest(Semaphore sem) {
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public void setSemaphore(Semaphore sem) {
        this.sem = sem;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    @Override
    public void process(TaskScheduler ts, JobManager jm) {
        String prefix = "\t";
        StringBuilder monitorData = new StringBuilder();
        monitorData.append(ts.getCoresMonitoringData(prefix));
        monitorData.append(prefix).append("<ResourceInfo>").append("\n");
        monitorData.append(ResourceManager.getPendingRequestsMonitorData(prefix + "\t"));
        for (Worker<?> r : ResourceManager.getAllWorkers()) {
            monitorData.append(prefix + "\t").append("<Resource id=\"" + r.getName() + "\">").append("\n");
            monitorData.append(r.getMonitoringData(prefix + "\t\t"));
            String runningTasks = ts.getRunningTasksMonitorData(r);
            if (runningTasks != null) {
                monitorData.append(prefix + "\t\t").append("<Status>").append("Running").append("</Status>").append("\n");
                monitorData.append(prefix + "\t\t").append("<Tasks>").append(runningTasks).append("</Tasks>").append("\n");
            } else {
                monitorData.append(prefix + "\t\t").append("<Status>").append("On Destroy").append("</Status>").append("\n");
                monitorData.append(prefix + "\t\t").append("<Tasks>").append("</Tasks>").append("\n");
            }
            monitorData.append(prefix + "\t").append("</Resource>").append("\n");
        }
        monitorData.append(prefix).append("</ResourceInfo>").append("\n");
        monitorData.append(prefix).append("<AccumulatedCost>" + ResourceManager.getTotalCost() + "</AccumulatedCost>").append("\n");
        this.response = monitorData.toString();
        this.sem.release();
    }

    @Override
    public TDRequest.TDRequestType getRequestType() {
        return TDRequest.TDRequestType.MONITOR_DATA;
    }
}

