/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.MethodWorker;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;

public class CloudMethodWorker
extends MethodWorker {
    private final LinkedList<PendingReduction> pendingReductions;
    private final CloudMethodResourceDescription toRemove;

    public CloudMethodWorker(CloudMethodResourceDescription description, COMPSsWorker worker, Integer maxTaskCount) {
        super(description.getName(), description, worker, maxTaskCount);
        this.toRemove = new CloudMethodResourceDescription();
        this.pendingReductions = new LinkedList();
    }

    public CloudMethodWorker(String name, CloudMethodResourceDescription description, TreeMap<String, AdaptorDescription> adaptorsDesc, HashMap<String, String> properties, Integer maxTaskCount) throws Exception {
        super(name, description, adaptorsDesc, properties, maxTaskCount);
        if (description != null) {
            ((MethodResourceDescription)this.description).setSlots(maxTaskCount);
            ((CloudMethodResourceDescription)this.description).setName(name);
        }
        this.toRemove = new CloudMethodResourceDescription();
        this.pendingReductions = new LinkedList();
    }

    @Override
    public Resource.Type getType() {
        return Resource.Type.WORKER;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<CPU>").append(((MethodResourceDescription)this.description).getProcessorCPUCount()).append("</CPU>").append("\n");
        sb.append(prefix).append("<Core>").append(((MethodResourceDescription)this.description).getProcessorCoreCount()).append("</Core>").append("\n");
        sb.append(prefix).append("<Memory>").append(((MethodResourceDescription)this.description).getMemoryPhysicalSize()).append("</Memory>").append("\n");
        sb.append(prefix).append("<Disk>").append(((MethodResourceDescription)this.description).getStorageElemSize()).append("</Disk>").append("\n");
        String providerName = ((CloudMethodResourceDescription)this.description).getProviderName();
        if (providerName == null) {
            providerName = new String("");
        }
        sb.append(prefix).append("<Provider>").append(providerName).append("</Provider>").append("\n");
        String imageName = ((CloudMethodResourceDescription)this.description).getName();
        if (imageName == null) {
            imageName = new String("");
        }
        sb.append(prefix).append("<Image>").append(imageName).append("</Image>").append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFeatures(CloudMethodResourceDescription increment) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.setProcessorCoreCount(this.available.getProcessorCoreCount() + increment.getProcessorCoreCount());
            this.available.setMemoryPhysicalSize(this.available.getMemoryPhysicalSize() + increment.getMemoryPhysicalSize());
        }
        methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            ((MethodResourceDescription)this.description).setProcessorCoreCount(((MethodResourceDescription)this.description).getProcessorCoreCount() + increment.getProcessorCoreCount());
            ((MethodResourceDescription)this.description).setMemoryPhysicalSize(((MethodResourceDescription)this.description).getMemoryPhysicalSize() + increment.getMemoryPhysicalSize());
        }
        this.updatedFeatures();
    }

    @Override
    public boolean reserveResource(MethodResourceDescription consumption) {
        if (!this.hasAvailable(consumption)) {
            return false;
        }
        return super.reserveResource(consumption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseResource(MethodResourceDescription consumption) {
        logger.debug("Checking cloud resources to release...");
        super.releaseResource(consumption);
        LinkedList<PendingReduction> linkedList = this.pendingReductions;
        synchronized (linkedList) {
            if (!this.pendingReductions.isEmpty()) {
                PendingReduction[] lpr;
                for (PendingReduction pRed : lpr = this.pendingReductions.toArray(new PendingReduction[this.pendingReductions.size()])) {
                    if (!this.isValidReduction(pRed.reduction)) break;
                    MethodResourceDescription methodResourceDescription = this.available;
                    synchronized (methodResourceDescription) {
                        this.available.setProcessorCoreCount(this.available.getProcessorCoreCount() - pRed.reduction.getProcessorCoreCount());
                        this.available.setMemoryPhysicalSize(this.available.getMemoryPhysicalSize() - pRed.reduction.getMemoryPhysicalSize());
                    }
                    methodResourceDescription = this.toRemove;
                    synchronized (methodResourceDescription) {
                        this.toRemove.setProcessorCoreCount(this.toRemove.getProcessorCoreCount() - pRed.reduction.getProcessorCoreCount());
                        this.toRemove.setMemoryPhysicalSize(this.toRemove.getMemoryPhysicalSize() - pRed.reduction.getMemoryPhysicalSize());
                    }
                    logger.debug("Releasing cloud resource " + this.getName());
                    pRed.sem.release();
                    this.pendingReductions.remove(pRed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Semaphore reduceFeatures(CloudMethodResourceDescription reduction) {
        MethodResourceDescription methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            ((MethodResourceDescription)this.description).setProcessorCoreCount(((MethodResourceDescription)this.description).getProcessorCoreCount() - reduction.getProcessorCoreCount());
            ((MethodResourceDescription)this.description).setMemoryPhysicalSize(((MethodResourceDescription)this.description).getMemoryPhysicalSize() - reduction.getMemoryPhysicalSize());
        }
        Semaphore sem = null;
        if (this.hasAvailable(reduction)) {
            MethodResourceDescription methodResourceDescription2 = this.available;
            synchronized (methodResourceDescription2) {
                this.available.setProcessorCoreCount(this.available.getProcessorCoreCount() - reduction.getProcessorCoreCount());
                this.available.setMemoryPhysicalSize(this.available.getMemoryPhysicalSize() - reduction.getMemoryPhysicalSize());
            }
        }
        if (this.taskCount > 0) {
            CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
            synchronized (cloudMethodResourceDescription) {
                this.toRemove.setProcessorCoreCount(this.toRemove.getProcessorCoreCount() + reduction.getProcessorCoreCount());
                this.toRemove.setMemoryPhysicalSize(this.toRemove.getMemoryPhysicalSize() + reduction.getMemoryPhysicalSize());
            }
            PendingReduction pRed = new PendingReduction(reduction);
            LinkedList<PendingReduction> linkedList = this.pendingReductions;
            synchronized (linkedList) {
                this.pendingReductions.add(pRed);
            }
            sem = pRed.sem;
        }
        this.updatedFeatures();
        return sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidReduction(MethodResourceDescription red) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            boolean memFits;
            boolean coreFits = this.available.getProcessorCoreCount() >= red.getProcessorCoreCount();
            boolean bl = memFits = this.available.getMemoryPhysicalSize() >= red.getMemoryPhysicalSize();
            if (logger.isDebugEnabled()) {
                logger.debug("Cloud Method reduction received:");
                logger.debug(this.available.getProcessorCoreCount() + " >= " + red.getProcessorCoreCount());
                logger.debug(this.available.getMemoryPhysicalSize() + " >= " + red.getMemoryPhysicalSize());
                logger.debug("With result: " + (coreFits & memFits));
            }
            return coreFits & memFits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
            synchronized (cloudMethodResourceDescription) {
                boolean memFits;
                boolean coreFits = this.available.getProcessorCoreCount() - this.toRemove.getProcessorCoreCount() >= consumption.getProcessorCoreCount();
                boolean bl = memFits = this.available.getMemoryPhysicalSize() - this.toRemove.getMemoryPhysicalSize() >= consumption.getMemoryPhysicalSize();
                if (logger.isDebugEnabled()) {
                    logger.debug("Cloud Method Worker received:");
                    logger.debug(this.available.getProcessorCoreCount() + " - " + this.toRemove.getProcessorCoreCount() + " >= " + consumption.getProcessorCoreCount());
                    logger.debug(this.available.getMemoryPhysicalSize() + " - " + this.toRemove.getMemoryPhysicalSize() + " >= " + consumption.getMemoryPhysicalSize());
                    logger.debug("With result: " + (coreFits & memFits));
                }
                return coreFits & memFits;
            }
        }
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = WORKER").append("\n");
        sb.append(prefix).append("CPU = ").append(((MethodResourceDescription)this.description).getProcessorCPUCount()).append("\n");
        sb.append(prefix).append("MEMORY = ").append(((MethodResourceDescription)this.description).getMemoryPhysicalSize()).append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldBeStopped() {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
            synchronized (cloudMethodResourceDescription) {
                return this.available.getProcessorCoreCount() == 0 && this.toRemove.getProcessorCoreCount() == 0;
            }
        }
    }

    private class PendingReduction {
        CloudMethodResourceDescription reduction;
        Semaphore sem;

        private PendingReduction(CloudMethodResourceDescription reduction) {
            this.reduction = reduction;
            this.sem = new Semaphore(0);
        }
    }
}

