/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.CoreManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class WorkerPool {
    private HashMap<String, Worker<?>> staticSet;
    private HashMap<String, CloudMethodWorker> criticalSet;
    private HashMap<String, CloudMethodWorker> nonCriticalSet;
    private LinkedList<Worker<?>>[] coreToResource;
    private int[] coreMaxTaskCount;
    private TreeSet<CloudMethodWorker> criticalOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerPool(int coreCount) {
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            this.staticSet = new HashMap();
            this.criticalSet = new HashMap();
            this.nonCriticalSet = new HashMap();
            this.coreToResource = new LinkedList[coreCount];
            this.coreMaxTaskCount = new int[coreCount];
            for (int i = 0; i < coreCount; ++i) {
                this.coreToResource[i] = new LinkedList();
                this.coreMaxTaskCount[i] = 0;
            }
            this.criticalOrder = new TreeSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStaticResource(Worker<?> newResource) {
        HashMap<String, Worker<?>> hashMap = this.staticSet;
        synchronized (hashMap) {
            this.staticSet.put(newResource.getName(), newResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicResource(CloudMethodWorker newResource) {
        Cloneable cloneable = this.criticalSet;
        synchronized (cloneable) {
            this.criticalSet.put(newResource.getName(), newResource);
        }
        cloneable = this.criticalOrder;
        synchronized (cloneable) {
            this.criticalOrder.add(newResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void coreElementUpdates(LinkedList<Integer> newCores) {
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            int[] slots;
            int oldCoreCount = this.coreToResource.length;
            int coreCount = CoreManager.getCoreCount();
            if (coreCount >= oldCoreCount) {
                void var6_7;
                LinkedList[] coreToResourceTmp = new LinkedList[coreCount];
                System.arraycopy(this.coreToResource, 0, coreToResourceTmp, 0, oldCoreCount);
                int n = this.coreToResource.length;
                while (var6_7 < coreCount) {
                    coreToResourceTmp[var6_7] = new LinkedList();
                    ++var6_7;
                }
                this.coreToResource = coreToResourceTmp;
                int[] nArray = new int[coreCount];
                System.arraycopy(this.coreMaxTaskCount, 0, nArray, 0, oldCoreCount);
                this.coreMaxTaskCount = nArray;
            }
            for (Worker<?> worker : this.staticSet.values()) {
                worker.updatedCoreElements(newCores);
                slots = worker.getSimultaneousTasks();
                for (Integer coreId : newCores) {
                    if (slots[coreId] <= 0) continue;
                    this.coreToResource[coreId].add(worker);
                    int n = coreId;
                    this.coreMaxTaskCount[n] = this.coreMaxTaskCount[n] + slots[coreId];
                }
            }
            for (Worker<?> worker : this.criticalSet.values()) {
                worker.updatedCoreElements(newCores);
                slots = worker.getSimultaneousTasks();
                for (Integer coreId : newCores) {
                    if (slots[coreId] <= 0) continue;
                    this.coreToResource[coreId].add(worker);
                    int n = coreId;
                    this.coreMaxTaskCount[n] = this.coreMaxTaskCount[n] + slots[coreId];
                }
            }
            for (Worker<?> worker : this.nonCriticalSet.values()) {
                worker.updatedCoreElements(newCores);
                slots = worker.getSimultaneousTasks();
                for (Integer coreId : newCores) {
                    if (slots[coreId] <= 0) continue;
                    this.coreToResource[coreId].add(worker);
                    int n = coreId;
                    this.coreMaxTaskCount[n] = this.coreMaxTaskCount[n] + slots[coreId];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Worker<?>> getStaticResources() {
        HashMap<String, Worker<?>> hashMap = this.staticSet;
        synchronized (hashMap) {
            return this.staticSet.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker<?> getStaticResource(String resourceName) {
        HashMap<String, Worker<?>> hashMap = this.staticSet;
        synchronized (hashMap) {
            return this.staticSet.get(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudMethodWorker getDynamicResource(String resourceName) {
        CloudMethodWorker resource = null;
        HashMap<String, CloudMethodWorker> hashMap = this.criticalSet;
        synchronized (hashMap) {
            resource = this.criticalSet.get(resourceName);
        }
        if (resource == null) {
            hashMap = this.nonCriticalSet;
            synchronized (hashMap) {
                resource = this.nonCriticalSet.get(resourceName);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<CloudMethodWorker> getDynamicResources() {
        LinkedList<CloudMethodWorker> resources = new LinkedList<CloudMethodWorker>();
        HashMap<String, CloudMethodWorker> hashMap = this.criticalSet;
        synchronized (hashMap) {
            resources.addAll(this.criticalSet.values());
        }
        hashMap = this.nonCriticalSet;
        synchronized (hashMap) {
            resources.addAll(this.nonCriticalSet.values());
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker<?> getResource(String resourceName) {
        Worker resource = null;
        HashMap<String, Worker<?>> hashMap = this.staticSet;
        synchronized (hashMap) {
            resource = this.staticSet.get(resourceName);
        }
        if (resource == null) {
            hashMap = this.criticalSet;
            synchronized (hashMap) {
                resource = this.criticalSet.get(resourceName);
            }
        }
        if (resource == null) {
            hashMap = this.nonCriticalSet;
            synchronized (hashMap) {
                resource = this.nonCriticalSet.get(resourceName);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceLinks(Worker<?> res) {
        int executableImpls = 0;
        int[] slots = res.getSimultaneousTasks();
        LinkedList<Worker<?>>[] linkedListArray = this.coreToResource;
        synchronized (this.coreToResource) {
            int[] nArray = this.coreMaxTaskCount;
            synchronized (this.coreMaxTaskCount) {
                for (int coreId = 0; coreId < slots.length; ++coreId) {
                    if (slots[coreId] <= 0) continue;
                    this.coreToResource[coreId].add(res);
                    int n = coreId;
                    this.coreMaxTaskCount[n] = this.coreMaxTaskCount[n] + slots[coreId];
                    ++executableImpls;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
            {
                if (executableImpls == 0) {
                    this.delete(res);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceLinks(Worker<?> res) {
        int[] slots = res.getSimultaneousTasks();
        LinkedList<Worker<?>>[] linkedListArray = this.coreToResource;
        synchronized (this.coreToResource) {
            int[] nArray = this.coreMaxTaskCount;
            synchronized (this.coreMaxTaskCount) {
                for (int coreId = 0; coreId < slots.length; ++coreId) {
                    if (slots[coreId] <= 0) continue;
                    this.coreToResource[coreId].remove(res);
                    int n = coreId;
                    this.coreMaxTaskCount[n] = this.coreMaxTaskCount[n] - slots[coreId];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void delete(Worker<?> resource) {
        LinkedList<Worker<?>>[] linkedListArray;
        String resourceName = resource.getName();
        HashMap<String, CloudMethodWorker> hashMap = this.criticalSet;
        // MONITORENTER : hashMap
        if (this.criticalSet.remove(resourceName) == null) {
            linkedListArray = this.nonCriticalSet;
            // MONITORENTER : this.nonCriticalSet
            this.nonCriticalSet.remove(resourceName);
            // MONITOREXIT : linkedListArray
        }
        // MONITOREXIT : hashMap
        int[] simTasks = resource.getSimultaneousTasks();
        linkedListArray = this.coreToResource;
        // MONITORENTER : this.coreToResource
        int[] nArray = this.coreMaxTaskCount;
        // MONITORENTER : this.coreMaxTaskCount
        int coreId = 0;
        while (true) {
            if (coreId >= CoreManager.getCoreCount()) {
                // MONITOREXIT : nArray
                // MONITOREXIT : linkedListArray
                return;
            }
            if (simTasks[coreId] > 0) {
                this.coreToResource[coreId].remove(resource);
                int n = coreId;
                this.coreMaxTaskCount[n] = this.coreMaxTaskCount[n] - simTasks[coreId];
            }
            ++coreId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCoreMaxTaskCount() {
        int[] nArray = this.coreMaxTaskCount;
        synchronized (this.coreMaxTaskCount) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.coreMaxTaskCount;
        }
    }

    public List<Integer> getExecutableCores(String res) {
        Worker<?> resource = this.getResource(res);
        if (resource == null) {
            return new LinkedList<Integer>();
        }
        return resource.getExecutableCores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineCriticalSet() {
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            int i;
            boolean[] runnable = new boolean[this.coreToResource.length];
            for (int i2 = 0; i2 < this.coreToResource.length; ++i2) {
                runnable[i2] = false;
            }
            for (Worker<?> res : this.staticSet.values()) {
                LinkedList<Integer> cores = res.getExecutableCores();
                for (i = 0; i < cores.size(); ++i) {
                    runnable[cores.get((int)i).intValue()] = true;
                }
            }
            for (CloudMethodWorker resource : this.criticalOrder) {
                String resourceName = resource.getName();
                boolean needed = false;
                for (i = 0; i < resource.getExecutableCores().size() && !needed; ++i) {
                    needed = needed || !runnable[resource.getExecutableCores().get(i)];
                }
                if (needed) {
                    for (i = 0; i < resource.getExecutableCores().size(); ++i) {
                        runnable[resource.getExecutableCores().get((int)i).intValue()] = true;
                    }
                    continue;
                }
                this.criticalSet.remove(resourceName);
                this.criticalOrder.remove(resource);
                this.nonCriticalSet.put(resourceName, resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CloudMethodWorker> getNonCriticalResources() {
        HashMap<String, CloudMethodWorker> hashMap = this.nonCriticalSet;
        synchronized (hashMap) {
            return this.nonCriticalSet.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CloudMethodWorker> getCriticalResources() {
        HashMap<String, CloudMethodWorker> hashMap = this.criticalSet;
        synchronized (hashMap) {
            return this.criticalSet.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Worker<?>> findAllResources() {
        int i;
        LinkedList workers = new LinkedList();
        HashMap<String, Worker<?>> hashMap = this.staticSet;
        synchronized (hashMap) {
            if (this.staticSet != null && !this.staticSet.isEmpty()) {
                Object[] arrayStaticSet = this.staticSet.values().toArray();
                for (i = 0; i < arrayStaticSet.length; ++i) {
                    workers.add((Worker)arrayStaticSet[i]);
                }
            }
        }
        hashMap = this.criticalSet;
        synchronized (hashMap) {
            if (this.criticalSet != null && !this.criticalSet.isEmpty()) {
                Object[] arrayCriticalSet = this.criticalSet.values().toArray();
                for (i = 0; i < arrayCriticalSet.length; ++i) {
                    workers.add((Worker)arrayCriticalSet[i]);
                }
            }
        }
        hashMap = this.nonCriticalSet;
        synchronized (hashMap) {
            if (this.nonCriticalSet != null && !this.nonCriticalSet.isEmpty()) {
                Object[] arrayNonCriticalSet = this.nonCriticalSet.values().toArray();
                for (i = 0; i < arrayNonCriticalSet.length; ++i) {
                    workers.add((Worker)arrayNonCriticalSet[i]);
                }
            }
        }
        return workers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Worker<?>> findCompatibleResources(int coreId) {
        LinkedList<Worker<?>>[] linkedListArray = this.coreToResource;
        synchronized (this.coreToResource) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (LinkedList)this.coreToResource[coreId].clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCriticalRemovalSafe(int[][] slotReductionImpls) {
        int coreCount = CoreManager.getCoreCount();
        int[] slotReductionCores = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            for (int implId = 0; implId < CoreManager.getCoreImplementations(coreId).length; ++implId) {
                if (slotReductionImpls[coreId][implId] <= slotReductionCores[coreId]) continue;
                slotReductionCores[coreId] = slotReductionImpls[coreId][implId];
            }
        }
        int[] slots = new int[coreCount];
        HashMap<String, CloudMethodWorker> implId = this.criticalSet;
        synchronized (implId) {
            for (Worker worker : this.criticalSet.values()) {
                int[] resSlots = worker.getSimultaneousTasks();
                for (int coreId = 0; coreId < coreCount; ++coreId) {
                    int n = coreId;
                    slots[n] = slots[n] + resSlots[coreId];
                }
            }
        }
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (slotReductionCores[coreId] <= 0 || slotReductionCores[coreId] < slots[coreId]) continue;
            return false;
        }
        return true;
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("RESOURCES = [").append("\n");
        for (Worker<?> worker : this.staticSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(worker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Static").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        for (Worker<?> worker : this.criticalSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(worker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Critical").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        for (Worker<?> worker : this.nonCriticalSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(worker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Non-Critical").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        sb.append(prefix).append("CORES = [").append("\n");
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            sb.append(prefix).append("\t").append("CORE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("ID = ").append(i).append("\n");
            sb.append(prefix).append("\t").append("\t").append("MAXTASKCOUNT = ").append(this.coreMaxTaskCount[i]).append("\n");
            sb.append(prefix).append("\t").append("\t").append("TORESOURCE = [").append("\n");
            for (Worker worker : this.coreToResource[i]) {
                sb.append(prefix).append("\t").append("\t").append("\t").append("RESOURCE = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("NAME = ").append(worker.getName()).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("SIMTASKS = ").append(worker.getSimultaneousTasks()[i]).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

