/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.binders.ForwardingRuleCreationBinder;
import org.jclouds.googlecomputeengine.domain.ForwardingRule;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ForwardingRuleCreationOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/forwardingRules")
@Consumes(value={"application/json"})
public interface ForwardingRuleApi {
    @Named(value="ForwardingRules:get")
    @GET
    @Path(value="/{forwardingRule}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ForwardingRule get(@PathParam(value="forwardingRule") String var1);

    @Named(value="ForwardingRules:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=ForwardingRuleCreationBinder.class)
    public Operation create(@PayloadParam(value="name") String var1, @PayloadParam(value="options") ForwardingRuleCreationOptions var2);

    @Named(value="ForwardingRules:delete")
    @DELETE
    @Path(value="/{forwardingRule}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="forwardingRule") String var1);

    @Named(value="ForwardingRules:setTarget")
    @POST
    @Path(value="/{forwardingRule}/setTarget")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    @Nullable
    public Operation setTarget(@PathParam(value="forwardingRule") String var1, @PayloadParam(value="target") URI var2);

    @Named(value="ForwardingRules:list")
    @GET
    public ListPage<ForwardingRule> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="ForwardingRules:list")
    @GET
    @Transform(value=ForwardingRulePages.class)
    public Iterator<ListPage<ForwardingRule>> list();

    @Named(value="ForwardingRules:list")
    @GET
    @Transform(value=ForwardingRulePages.class)
    public Iterator<ListPage<ForwardingRule>> list(ListOptions var1);

    public static final class ForwardingRulePages
    extends BaseCallerArg0ToIteratorOfListPage<ForwardingRule, ForwardingRulePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        ForwardingRulePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<ForwardingRule>> fetchNextPage(final String regionName, final ListOptions options) {
            return new Function<String, ListPage<ForwardingRule>>(){

                @Override
                public ListPage<ForwardingRule> apply(String pageToken) {
                    return ForwardingRulePages.this.api.forwardingRulesInRegion(regionName).listPage(pageToken, options);
                }
            };
        }
    }
}

