/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sshj;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.sshj.AuthAgent;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Named;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.method.AuthMethod;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.sshj.SshjSshClient;

public class SSHClientConnection
implements SshjSshClient.Connection<SSHClient> {
    private Optional<Connector> agentConnector;
    @Resource
    @Named(value="jclouds.ssh")
    protected Logger logger = Logger.NULL;
    private final HostAndPort hostAndPort;
    private final LoginCredentials loginCredentials;
    private final int connectTimeout;
    private final int sessionTimeout;
    @VisibleForTesting
    transient SSHClient ssh;

    public static Builder builder() {
        return new Builder();
    }

    private SSHClientConnection(HostAndPort hostAndPort, LoginCredentials loginCredentials, int connectTimeout, int sessionTimeout, Optional<Connector> agentConnector) {
        this.hostAndPort = Preconditions.checkNotNull(hostAndPort, "hostAndPort");
        this.loginCredentials = Preconditions.checkNotNull(loginCredentials, "loginCredentials for %", hostAndPort);
        this.connectTimeout = connectTimeout;
        this.sessionTimeout = sessionTimeout;
        this.agentConnector = Preconditions.checkNotNull(agentConnector, "agentConnector for %", hostAndPort);
    }

    @Override
    public void clear() {
        if (this.ssh != null && this.ssh.isConnected()) {
            try {
                this.ssh.disconnect();
            }
            catch (AssertionError e) {
            }
            catch (IOException e) {
                this.logger.debug("<< exception disconnecting from %s: %s", e, e.getMessage());
            }
            this.ssh = null;
        }
    }

    @Override
    public SSHClient create() throws Exception {
        this.ssh = new SSHClient();
        this.ssh.addHostKeyVerifier(new PromiscuousVerifier());
        if (this.connectTimeout != 0) {
            this.ssh.setConnectTimeout(this.connectTimeout);
        }
        if (this.sessionTimeout != 0) {
            this.ssh.setTimeout(this.sessionTimeout);
        }
        this.ssh.connect(this.hostAndPort.getHostText(), this.hostAndPort.getPortOrDefault(22));
        if (this.loginCredentials.hasUnencryptedPrivateKey()) {
            OpenSSHKeyFile key = new OpenSSHKeyFile();
            key.init(this.loginCredentials.getOptionalPrivateKey().get(), null);
            this.ssh.authPublickey(this.loginCredentials.getUser(), key);
        } else if (this.loginCredentials.getOptionalPassword().isPresent()) {
            this.ssh.authPassword(this.loginCredentials.getUser(), this.loginCredentials.getOptionalPassword().get());
        } else if (this.agentConnector.isPresent()) {
            AgentProxy proxy = new AgentProxy(this.agentConnector.get());
            this.ssh.auth(this.loginCredentials.getUser(), SSHClientConnection.getAuthMethods(proxy));
        }
        return this.ssh;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public LoginCredentials getLoginCredentials() {
        return this.loginCredentials;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Optional<Connector> getAgentConnector() {
        return this.agentConnector;
    }

    public SSHClient getSSHClient() {
        return this.ssh;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSHClientConnection that = (SSHClientConnection)SSHClientConnection.class.cast(o);
        return Objects.equal(this.hostAndPort, that.hostAndPort) && Objects.equal(this.loginCredentials, that.loginCredentials) && Objects.equal(this.ssh, that.ssh);
    }

    public int hashCode() {
        return Objects.hashCode(this.hostAndPort, this.loginCredentials, this.ssh);
    }

    public String toString() {
        return Objects.toStringHelper("").add("hostAndPort", this.hostAndPort).add("loginUser", this.loginCredentials.getUser()).add("ssh", this.ssh != null ? Integer.valueOf(this.ssh.hashCode()) : null).add("connectTimeout", this.connectTimeout).add("sessionTimeout", this.sessionTimeout).toString();
    }

    private static List<AuthMethod> getAuthMethods(AgentProxy agent) throws Buffer.BufferException {
        ImmutableList.Builder identities = ImmutableList.builder();
        for (Identity identity : agent.getIdentities()) {
            identities.add(new AuthAgent(agent, identity));
        }
        return identities.build();
    }

    public static class Builder {
        protected HostAndPort hostAndPort;
        protected LoginCredentials loginCredentials;
        protected int connectTimeout;
        protected int sessionTimeout;
        protected Optional<Connector> agentConnector;

        public Builder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Builder loginCredentials(LoginCredentials loginCredentials) {
            this.loginCredentials = loginCredentials;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder sessionTimeout(int sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder agentConnector(Optional<Connector> agentConnector) {
            this.agentConnector = agentConnector;
            return this;
        }

        public SSHClientConnection build() {
            return new SSHClientConnection(this.hostAndPort, this.loginCredentials, this.connectTimeout, this.sessionTimeout, this.agentConnector);
        }

        protected Builder fromSSHClientConnection(SSHClientConnection in) {
            return this.hostAndPort(in.getHostAndPort()).connectTimeout(in.getConnectTimeout()).loginCredentials(in.getLoginCredentials()).sessionTimeout(in.getSessionTimeout()).agentConnector(in.getAgentConnector());
        }
    }
}

