/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.job;

import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.resources.Resource;
import org.apache.log4j.Logger;

public abstract class Job<T extends COMPSsNode> {
    protected static final int FIRST_JOB_ID = 1;
    protected static int nextJobId = 1;
    protected static final String lang = System.getProperty("it.lang");
    protected static final boolean tracing = System.getProperty("it.tracing") != null && Integer.parseInt(System.getProperty("it.tracing")) > 0;
    protected int jobId = nextJobId++;
    protected final int taskId;
    protected final TaskParams taskParams;
    protected final Implementation<?> impl;
    protected final Resource worker;
    protected final JobListener listener;
    protected JobHistory history;
    protected int transferId;
    protected static final Boolean workerDebug = Logger.getLogger("integratedtoolkit.Worker").isDebugEnabled();
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    protected static final boolean debug = logger.isDebugEnabled();

    public Job(int taskId, TaskParams task, Implementation<?> impl, Resource res, JobListener listener) {
        this.taskId = taskId;
        this.history = JobHistory.NEW;
        this.taskParams = task;
        this.impl = impl;
        this.worker = res;
        this.listener = listener;
    }

    public int getJobId() {
        return this.jobId;
    }

    public TaskParams getTaskParams() {
        return this.taskParams;
    }

    public JobHistory getHistory() {
        return this.history;
    }

    public void setHistory(JobHistory newHistoryState) {
        this.history = newHistoryState;
    }

    public Resource getResource() {
        return this.worker;
    }

    public T getResourceNode() {
        return (T)this.worker.getNode();
    }

    public JobListener getListener() {
        return this.listener;
    }

    public Implementation<?> getImplementation() {
        return this.impl;
    }

    public void setTransferGroupId(int transferId) {
        this.transferId = transferId;
    }

    public int getTransferGroupId() {
        return this.transferId;
    }

    public abstract String toString();

    public abstract void submit() throws Exception;

    public abstract void stop() throws Exception;

    public Object getReturnValue() {
        return null;
    }

    public abstract String getHostName();

    public abstract JobKind getKind();

    public static interface JobListener {
        public void jobCompleted(Job<?> var1);

        public void jobFailed(Job<?> var1, JobEndStatus var2);

        public static enum JobEndStatus {
            OK,
            TO_RESCHEDULE,
            TRANSFERS_FAILED,
            SUBMISSION_FAILED,
            EXECUTION_FAILED;

        }
    }

    public static enum JobKind {
        METHOD,
        SERVICE;

    }

    public static enum JobHistory {
        NEW,
        RESUBMITTED_FILES,
        RESUBMITTED,
        RESCHEDULED;

    }
}

