/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.resources.MethodResourceDescription;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CloudImageManager {
    private HashMap<String, CloudImageDescription> images = new HashMap();

    public void add(CloudImageDescription cid) {
        this.images.put(cid.getName(), cid);
    }

    public LinkedList<CloudImageDescription> getCompatibleImages(MethodResourceDescription requested) {
        LinkedList<CloudImageDescription> compatiblesList = new LinkedList<CloudImageDescription>();
        for (CloudImageDescription cid : this.images.values()) {
            String imageArch = cid.getArch();
            String reqArch = requested.getProcessorArchitecture();
            if (imageArch.compareTo("[unassigned]") != 0 && reqArch.compareTo("[unassigned]") != 0 && imageArch.compareTo(reqArch) != 0) continue;
            String imageOS = cid.getOperativeSystem();
            String reqOS = requested.getOperatingSystemType();
            if (imageOS.compareTo("[unassigned]") != 0 && reqOS.compareTo("[unassigned]") != 0 && imageOS.compareTo(reqOS) != 0 || !cid.getSoftwareApps().containsAll(requested.getAppSoftware())) continue;
            compatiblesList.add(cid);
        }
        return compatiblesList;
    }

    public Set<String> getAllImageNames() {
        return this.images.keySet();
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("IMAGES = [").append("\n");
        for (Map.Entry<String, CloudImageDescription> image : this.images.entrySet()) {
            String imageName = image.getKey();
            sb.append(prefix).append("\t").append("IMAGE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("NAME = ").append(imageName).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

