/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.util.RequestDispatcher;
import integratedtoolkit.util.RequestQueue;
import java.util.concurrent.Semaphore;

public class ThreadPool {
    private final int size;
    private final String name;
    private final Thread[] workerThreads;
    private final RequestDispatcher<?> runObject;
    private final RequestQueue<?> queue;
    private final Semaphore sem;

    public ThreadPool(int size, String name, RequestDispatcher<?> runObject) {
        this.size = size;
        this.workerThreads = new Thread[this.size];
        this.name = name;
        this.runObject = runObject;
        this.runObject.setPool(this);
        this.queue = runObject.getQueue();
        this.sem = new Semaphore(size);
    }

    public void startThreads() {
        int i = 0;
        for (Thread t : this.workerThreads) {
            t = new Thread(this.runObject);
            t.setName(this.name + " pool thread # " + i++);
            t.start();
        }
        this.sem.acquireUninterruptibly(this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads() {
        RequestQueue<?> requestQueue = this.queue;
        synchronized (requestQueue) {
            for (int i = 0; i < this.size; ++i) {
                this.queue.addToFront(null);
            }
            this.queue.wakeUpAll();
        }
        this.sem.acquireUninterruptibly(this.size);
    }

    public void threadEnd() {
        this.sem.release();
    }

    public int getNumThreads() {
        return this.workerThreads.length;
    }
}

