/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.Node;
import es.bsc.comm.event.Event;
import es.bsc.comm.stage.Reception;
import es.bsc.comm.stage.Submission;
import es.bsc.comm.stage.Transfer;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class EventManager<T extends Event> {
    protected static final Logger LOGGER = Logger.getLogger("Communication");
    private boolean isBlocked = false;
    protected LinkedList<T> events = new LinkedList();
    private boolean stopReceived = false;
    private final MessageHandler mh;

    public EventManager(MessageHandler messageReceiver) {
        this.mh = messageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOGGER.info("Event Manager started");
        LinkedList<Object> privateEvents = new LinkedList();
        while (!this.stopReceived || !this.events.isEmpty()) {
            this.specificActions();
            EventManager eventManager = this;
            synchronized (eventManager) {
                LinkedList<T> list = this.events;
                this.events = privateEvents;
                privateEvents = list;
            }
            while (!privateEvents.isEmpty()) {
                Event event = (Event)privateEvents.removeFirst();
                LOGGER.debug("Processing event " + (Object)((Object)event.getEventType()));
                this.processEvent(event);
            }
            LOGGER.debug("Waiting for events");
            this.waitForEvents();
        }
        LOGGER.info("Event Manager begins shutdown process");
        this.handleSpecificStop();
        this.mh.shutdown();
        LOGGER.info("Event Manager stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForEvents() {
        if (this.events.isEmpty() && !this.stopReceived) {
            EventManager eventManager = this;
            synchronized (eventManager) {
                if (this.events.isEmpty() && !this.stopReceived) {
                    this.isBlocked = true;
                    try {
                        LOGGER.debug("Event Manager wait");
                        this.wait(this.waitEventsTimeout());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.isBlocked = false;
                }
            }
        }
    }

    private void processEvent(Event e) {
        LOGGER.debug("Processing " + e);
        e.processEventOnConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(T e) {
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.events.add(e);
            if (this.isBlocked) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stopReceived = true;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.isBlocked) {
                this.notify();
            }
        }
    }

    public void notifyError(Connection con, Transfer t, CommException exception) {
        this.mh.errorHandler(con, t, exception);
    }

    public void dataReceived(Connection c, Reception t) {
        this.mh.dataReceived(c, t);
    }

    public void commandReceived(Connection c, Reception t) {
        this.mh.commandReceived(c, t);
    }

    public void writeFinished(Connection c, Submission t) {
        this.mh.writeFinished(c, t);
    }

    public void connectionFinished(Connection c) {
        this.mh.connectionFinished(c);
    }

    public abstract void init(String var1) throws CommException;

    public abstract void startServer(Node var1) throws CommException;

    public abstract Connection startConnection(Node var1);

    protected abstract long waitEventsTimeout();

    protected abstract void specificActions();

    protected abstract void handleSpecificStop();

    public abstract void shutdown(Connection var1);
}

