/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.Node;
import es.bsc.comm.nio.NIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class TransferManager
extends Thread {
    public static final String LOGGER_NAME = "Communication";
    private static final Logger LOGGER = Logger.getLogger("Communication");
    private static final String PROPERTIES_ERROR = "Error loading properties file";
    private EventManager<?> em;

    public TransferManager() {
        super("TransferManager");
    }

    public void init(String eventManagerClassName, String properties, MessageHandler mh) throws CommException {
        LOGGER.debug("TransferManager init");
        Thread.currentThread().setName("TransferManager");
        try {
            Constructor<?> constrEventManager = Class.forName(eventManagerClassName).getConstructor(MessageHandler.class);
            this.em = (EventManager)constrEventManager.newInstance(mh);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Can not find adaptor class " + eventManagerClassName + ".", e);
            throw new NIOException(NIOException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Class " + eventManagerClassName + " has no valid constructor.", e);
            throw new NIOException(NIOException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (InstantiationException e) {
            LOGGER.error("Can not instantiate adaptor " + eventManagerClassName + ".", e);
            throw new NIOException(NIOException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access on adaptor " + eventManagerClassName + " creation", e);
            throw new NIOException(NIOException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Illegal argument on adaptor " + eventManagerClassName + " creation", e);
            throw new NIOException(NIOException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Wrong target for " + eventManagerClassName + " invocation", e);
            throw new NIOException(NIOException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        catch (Exception e) {
            LOGGER.error(e);
            throw new NIOException(NIOException.ErrorType.LOADING_EVENT_MANAGER_CLASS, e);
        }
        try {
            this.em.init(properties);
        }
        catch (Exception e) {
            LOGGER.error(PROPERTIES_ERROR, e);
            throw new NIOException(NIOException.ErrorType.EVENT_MANAGER_INIT, e);
        }
        try {
            mh.init();
        }
        catch (Exception e) {
            LOGGER.error(PROPERTIES_ERROR, e);
            throw new NIOException(NIOException.ErrorType.MESSAGE_HANDLER_INIT, e);
        }
    }

    @Override
    public void run() {
        this.em.run();
    }

    public void startServer(Node n) throws CommException {
        LOGGER.debug("TransferManager Start Server");
        this.em.startServer(n);
    }

    public Connection startConnection(Node node) {
        return this.em.startConnection(node);
    }

    public void shutdown(Connection notifyTo) {
        LOGGER.debug("TransferManager shutdown");
        this.em.shutdown(notifyTo);
    }
}

