/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.stage;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.nio.NIOProperties;
import es.bsc.comm.stage.Stage;
import es.bsc.comm.stage.Transfer;
import es.bsc.comm.util.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class Reception
extends Transfer {
    private static int tokens = NIOProperties.MAX_RECEIVES;
    private static LinkedList<InternalConnection> pausedConnections = new LinkedList();
    private boolean destInit;
    private OutputStream streamOut;
    private boolean hasToken = false;
    private Stage.Token token;

    public Reception() {
        super(true);
        this.remainingSize = 0L;
        this.destInit = false;
    }

    public Reception(boolean notifyErrors) {
        super(notifyErrors);
        this.remainingSize = 0L;
        this.destInit = false;
    }

    public Reception(Transfer.Destination destination) {
        super(true);
        this.type = Transfer.Type.DATA;
        this.destination = destination;
        this.destInit = true;
    }

    public Reception(Transfer.Destination destination, boolean notifyErrors) {
        super(notifyErrors);
        this.type = Transfer.Type.DATA;
        this.destination = destination;
        this.destInit = true;
    }

    public Reception(Transfer.Type type) {
        super(true);
        this.type = type;
        this.destination = Transfer.Destination.OBJECT;
        this.destInit = false;
    }

    public Reception(Transfer.Type type, boolean notifyErrors) {
        super(notifyErrors);
        this.type = type;
        this.destination = Transfer.Destination.OBJECT;
        this.destInit = false;
    }

    public void initTransfer(Stage.Token t) throws FileNotFoundException {
        byte[] header = t.get(16);
        ByteBuffer bb = ByteBuffer.wrap(header);
        long size = bb.getLong();
        if (!this.destInit) {
            this.destInit = true;
            this.type = Transfer.Type.values()[bb.getInt()];
            this.destination = Transfer.Destination.values()[bb.getInt()];
        }
        this.setSize(size);
        this.openStream();
    }

    private void openStream() throws FileNotFoundException {
        this.streamOut = this.destination == Transfer.Destination.FILE ? new FileOutputStream(this.getFileName(), true) : new ByteArrayOutputStream((int)this.totalSize);
    }

    private void write(Stage.Token t) throws IOException, ClassNotFoundException {
        long length = Math.min(this.remainingSize, (long)t.length());
        byte[] content = t.get((int)length);
        this.streamOut.write(content);
        this.remainingSize -= (long)content.length;
        if (this.remainingSize == 0L) {
            this.closeStream();
        }
    }

    private void closeStream() throws ClassNotFoundException, IOException {
        if (this.destination != Transfer.Destination.FILE) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.streamOut;
            this.array = baos.toByteArray();
            if (this.destination == Transfer.Destination.OBJECT) {
                this.object = Serializer.deserialize(this.array);
            }
        }
        try {
            this.streamOut.close();
        }
        catch (IOException e) {
            LOGGER.error("Error closing output stream on connection " + this);
        }
    }

    @Override
    public Transfer.Direction getDirection() {
        return Transfer.Direction.RECEIVE;
    }

    public void setReceptionDefaultFileName(String fname) {
        this.fileName = fname;
    }

    @Override
    public void start(InternalConnection connection, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) {
        this.token = new Stage.Token();
        --tokens;
        this.hasToken = true;
    }

    @Override
    public void progress(InternalConnection connection, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) throws IOException, ClassNotFoundException {
        while (!this.token.isCompletelyFilled() && !received.isEmpty()) {
            this.loadToken(this.token, received);
            if (!this.token.isCompletelyFilled()) continue;
            if (!this.destInit || !this.sizeInit) {
                this.initTransfer(this.token);
            }
            this.write(this.token);
            if (this.remainingSize <= 0L) continue;
            this.token = new Stage.Token();
        }
    }

    @Override
    public boolean checkViability(boolean closedCommunication, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) throws NIOException {
        if (!closedCommunication || !received.isEmpty()) {
            return tokens > 0;
        }
        throw new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, new Exception("Channel was already closed for connection " + this));
    }

    @Override
    public void pause(InternalConnection ic) {
        pausedConnections.add(ic);
    }

    @Override
    public boolean isComplete(LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) {
        return this.sizeInit && this.remainingSize == 0L;
    }

    @Override
    public void notifyCompletion(Connection c, EventManager<?> em) {
        if (this.isData()) {
            em.dataReceived(c, this);
        } else if (this.isCommand()) {
            em.commandReceived(c, this);
        }
        ++tokens;
        this.hasToken = false;
        if (pausedConnections.size() > 0) {
            InternalConnection ic = pausedConnections.removeFirst();
            ic.resume();
        }
    }

    @Override
    public void notifyError(Connection c, EventManager<?> em, CommException exc) {
        if (this.notifyErrors) {
            em.notifyError(c, this, exc);
        }
        if (this.hasToken) {
            ++tokens;
            this.hasToken = false;
            if (pausedConnections.size() > 0) {
                InternalConnection ic = pausedConnections.removeFirst();
                ic.resume();
            }
        }
    }
}

