/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio;

import es.bsc.cepbatools.extrae.Wrapper;
import integratedtoolkit.util.StreamGobbler;
import integratedtoolkit.util.Tracer;
import java.io.File;
import java.io.IOException;

public class NIOTracer
extends Tracer {
    private static String scriptDir = "";
    private static String workingDir = "";
    private static String nodeName = "master";
    private static final int ID = 121;
    public static final String TRANSFER_END = "0";

    public static void startTracing(String workerName, String workerUser, String workerHost, Integer numThreads) {
        if (numThreads <= 0) {
            if (debug) {
                logger.debug("Resource " + workerName + " has 0 slots, it won't appear in the trace");
            }
            return;
        }
        if (debug) {
            logger.debug("NIO uri File: any:///" + System.getProperty("it.appLogDir") + "/trace/tracer.out");
            logger.debug("any:///" + System.getProperty("it.appLogDir") + "/trace/tracer.out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWorkerInfo(String scriptDir, String nodeName, String workingDir, int hostID) {
        NIOTracer.scriptDir = scriptDir;
        NIOTracer.workingDir = workingDir;
        NIOTracer.nodeName = nodeName;
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.SetTaskID(hostID);
            Wrapper.SetNumTasks(hostID + 1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (debug) {
                logger.debug("Tracer worker for host " + hostID + " and: " + NIOTracer.scriptDir + ", " + NIOTracer.workingDir + ", " + NIOTracer.nodeName);
            }
            return;
        }
    }

    public static void emitDataTransferEvent(String data) {
        int transferID;
        boolean dataTransfer = !data.startsWith("worker") && !data.startsWith("tracing");
        int n = transferID = data.equals(TRANSFER_END) ? 0 : Math.abs(data.hashCode());
        if (dataTransfer) {
            NIOTracer.emitEvent(transferID, 8000004);
        }
        if (debug) {
            logger.debug((dataTransfer ? "E" : "Not E") + "mitting synchronized data transfer event [name, id] = [" + data + " , " + transferID + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEventAndCounters(int taskId, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Eventandcounters(eventType, taskId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (debug) {
                logger.debug("Emitting synchronized event with HW counters [type, taskId] = [" + eventType + " , " + taskId + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitCommEvent(boolean send, int partnerID, int tag) {
        int size = 0;
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Comm(send, tag, size, partnerID, 121L);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (debug) {
                logger.debug("Emitting communication event [" + (send ? "SEND" : "REC") + "] " + tag + ", " + size + ", " + partnerID + ", " + 121 + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePackage() {
        NIOTracer.masterEventStart(Tracer.Event.STOP.getId());
        if (debug) {
            logger.debug("Generating package of " + nodeName + ", with " + scriptDir);
        }
        NIOTracer.masterEventFinish();
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            Wrapper.Fini();
            // ** MonitorExit[var0] (shouldn't be in output)
            ProcessBuilder pb = new ProcessBuilder(scriptDir + File.separator + "trace.sh", "package", workingDir, nodeName);
            pb.environment().remove("LD_PRELOAD");
            Process p = null;
            try {
                p = pb.start();
            }
            catch (IOException e) {
                logger.error("Error generating " + nodeName + " package", e);
                return;
            }
            if (debug) {
                StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out);
                StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err);
                outputGobbler.start();
                errorGobbler.start();
                logger.debug("Created globbers");
            }
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    logger.error("Error generating " + nodeName + " package, exit code " + exitCode);
                }
            }
            catch (InterruptedException e) {
                logger.error("Error generating " + nodeName + " package (interruptedException) : " + e.getMessage());
            }
            if (debug) {
                logger.debug("Finish generating");
            }
            return;
        }
    }
}

