/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class RuntimeConfigManager {
    private final PropertiesConfiguration config;

    public RuntimeConfigManager(String pathToConfigFile) throws ConfigurationException {
        this.config = new PropertiesConfiguration(pathToConfigFile);
    }

    public RuntimeConfigManager(URL pathToConfigFile) throws ConfigurationException {
        this.config = new PropertiesConfiguration(pathToConfigFile);
    }

    public RuntimeConfigManager(InputStream stream) throws ConfigurationException {
        this.config = new PropertiesConfiguration();
        this.config.load(stream);
    }

    public RuntimeConfigManager(File file) throws ConfigurationException {
        this.config = new PropertiesConfiguration(file);
    }

    public String getDeploymentId() {
        return this.config.getString("it.uuid");
    }

    public void setDeploymentId(String uuid) {
        this.config.setProperty("it.uuid", uuid);
    }

    public String getMasterPort() {
        return this.config.getString("it.masterPort");
    }

    public void setMasterPort(String port) {
        this.config.setProperty("it.masterPort", port);
    }

    public String getAppName() {
        return this.config.getString("it.appName");
    }

    public void setCOMPSsBaseLogDir(String dir) {
        this.config.setProperty("it.baseLogDir", dir);
    }

    public String getCOMPSsBaseLogDir() {
        return this.config.getString("it.baseLogDir");
    }

    public void setAppName(String name) {
        this.config.setProperty("it.appName", name);
    }

    public String getProjectFile() {
        return this.config.getString("it.project.file");
    }

    public void setProjectFile(String location) {
        this.config.setProperty("it.project.file", location);
    }

    public String getProjectSchema() {
        return this.config.getString("it.project.schema");
    }

    public void setProjectSchema(String location) {
        this.config.setProperty("it.project.schema", location);
    }

    public String getResourcesFile() {
        return this.config.getString("it.resources.file");
    }

    public void setResourcesFile(String location) {
        this.config.setProperty("it.resources.file", location);
    }

    public String getResourcesSchema() {
        return this.config.getString("it.resources.schema");
    }

    public void setResourcesSchema(String location) {
        this.config.setProperty("it.resources.schema", location);
    }

    public String getScheduler() {
        return this.config.getString("it.scheduler");
    }

    public void setScheduler(String implementingClass) {
        this.config.setProperty("it.scheduler", implementingClass);
    }

    public String getLog4jConfiguration() {
        return this.config.getString("log4j.configuration");
    }

    public void setLog4jConfiguration(String location) {
        this.config.setProperty("log4j.configuration", location);
    }

    public void setCommAdaptor(String adaptor) {
        this.config.setProperty("it.comm", adaptor);
    }

    public String getCommAdaptor() {
        return this.config.getString("it.comm");
    }

    public String getGATBrokerAdaptor() {
        return this.config.getString("it.gat.broker.adaptor");
    }

    public void setGATBrokerAdaptor(String adaptor) {
        this.config.setProperty("it.gat.broker.adaptor", adaptor);
    }

    public String getGATFileAdaptor() {
        return this.config.getString("it.gat.file.adaptor");
    }

    public void setGATFileAdaptor(String adaptor) {
        this.config.setProperty("it.gat.file.adaptor", adaptor);
    }

    public void setGraph(boolean graph) {
        this.config.setProperty("it.graph", graph);
    }

    public boolean isGraph() {
        return this.config.getBoolean("it.graph", false);
    }

    public void setTracing(int tracing) {
        this.config.setProperty("it.tracing", tracing);
    }

    public int getTracing() {
        return this.config.getInt("it.tracing", 0);
    }

    public boolean isPresched() {
        return this.config.getBoolean("it.presched", false);
    }

    public void setPresched(boolean presched) {
        this.config.setProperty("it.presched", presched);
    }

    public void setMonitorInterval(long seconds) {
        this.config.setProperty("it.monitor", seconds);
    }

    public long getMonitorInterval() {
        return this.config.getLong("it.monitor");
    }

    public String getLang() {
        return this.config.getString("it.lang", "java");
    }

    public void setLang(String lang) {
        this.config.setProperty("it.lang", lang);
    }

    public String getWorkerCP() {
        return this.config.getString("it.worker.cp");
    }

    public void setWorkerCP(String classpath) {
        this.config.setProperty("it.worker.cp", classpath);
    }

    public String getContext() {
        return this.config.getString("it.context");
    }

    public void setContext(String context) {
        this.config.setProperty("it.context", context);
    }

    public String getGATAdaptor() {
        return this.config.getString("gat.adaptor.path", System.getenv("GAT_LOCATION") + "/lib/adaptors");
    }

    public void setGATAdaptor(String adaptorPath) {
        this.config.setProperty("gat.adaptor.path", adaptorPath);
    }

    public boolean isGATDebug() {
        return this.config.getBoolean("gat.debug", false);
    }

    public void setGATDebug(boolean debug) {
        this.config.setProperty("gat.debug", debug);
    }

    public void setServiceName(String serviceName) {
        this.config.setProperty("it.serviceName", serviceName);
    }

    public String getServiceName() {
        return this.config.getString("it.serviceName");
    }

    public void save() throws ConfigurationException {
        this.config.save();
    }

    public boolean isToFile() {
        return this.config.getBoolean("it.to.file", false);
    }
}

