/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import es.bsc.cepbatools.extrae.Wrapper;
import integratedtoolkit.comm.Comm;
import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.operation.TracingCopyListener;
import integratedtoolkit.types.data.operation.TracingCopyTransferable;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class Tracer {
    public static final int DEFAULT_NUM_THREADS = 16;
    private static final String taskDesc = "Task";
    private static final String apiDesc = "Runtime";
    private static final String taskIdDesc = "Task IDs";
    private static final String dataTransfersDesc = "Data Transfers";
    protected static final String TRACE_SCRIPT = "trace.sh";
    protected static final String traceOutRelativePath = "/trace/tracer.out";
    protected static final String traceErrRelativePath = "/trace/tracer.err";
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.JobManager");
    protected static final boolean debug = logger.isDebugEnabled();
    protected static final String ERROR_TRACE_DIR = "ERROR: Cannot create trace directory";
    protected static final int TASKS_FUNC_TYPE = 8000000;
    protected static final int RUNTIME_EVENTS = 8000001;
    protected static final int TASKS_ID_TYPE = 8000002;
    protected static final int TASK_TRANSFERS = 8000003;
    protected static final int DATA_TRANSFERS = 8000004;
    public static final int EVENT_END = 0;
    public static final int NOT_ENABLED = 0;
    public static final int BASIC_MODE = 1;
    public static final int ADVANCED_MODE = 2;
    protected static int tracing_level;
    private static String traceDirPath;
    private static Map<String, TraceHost> hostToSlots;
    private static AtomicInteger hostId;

    public static void init(int level) {
        if (debug) {
            logger.debug("Initializing tracing");
        }
        hostId = new AtomicInteger(1);
        hostToSlots = new HashMap<String, TraceHost>();
        traceDirPath = Comm.appHost.getAppLogDirPath() + "trace" + File.separator;
        if (!new File(traceDirPath).mkdir()) {
            ErrorManager.error(ERROR_TRACE_DIR);
        }
        Wrapper.SetTaskID(0);
        Wrapper.SetNumTasks(1);
        tracing_level = level;
    }

    public static boolean advancedModeEnabled() {
        return tracing_level == 2;
    }

    public static boolean basicModeEnabled() {
        return tracing_level == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enablePThreads() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disablePThreads() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String getTraceDirPath() {
        return traceDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerHost(String name, int slots) {
        int id;
        if (debug) {
            logger.debug("Tracing: Registering host " + name + " in the tracing system");
        }
        Map<String, TraceHost> map = hostToSlots;
        synchronized (map) {
            if (hostToSlots.containsKey(name)) {
                if (debug) {
                    logger.debug("Host " + name + " already in tracing system, skipping");
                }
                return -1;
            }
            id = hostId.getAndIncrement();
            hostToSlots.put(name, new TraceHost(slots));
        }
        return id;
    }

    public static int getNextSlot(String host) {
        int slot = hostToSlots.get(host).getNextSlot();
        if (debug) {
            logger.debug("Tracing: Getting slot " + slot + " of host " + host);
        }
        return slot;
    }

    public static void freeSlot(String host, int slot) {
        if (debug) {
            logger.debug("Tracing: Freeing slot " + slot + " of host " + host);
        }
        hostToSlots.get(host).freeSlot(slot);
    }

    public static int getDataTransfersType() {
        return 8000004;
    }

    public static int getTaskTransfersType() {
        return 8000003;
    }

    public static int getTaskEventsType() {
        return 8000000;
    }

    public static int getTaskSchedulingType() {
        return 8000002;
    }

    public static Event getAPRequestEvent(String eventType) {
        return Event.valueOf(eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEvent(long eventID, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Event(eventType, eventID);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (debug) {
                logger.debug("Emitting synchronized event [type, id] = [" + eventType + " , " + eventID + "]");
            }
            return;
        }
    }

    public static void masterEventStart(int taskId) {
        Tracer.emitEvent(taskId, 8000001);
    }

    public static void masterEventFinish() {
        Tracer.emitEvent(0L, 8000001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fini() {
        if (debug) {
            logger.debug("Tracing: finalizing");
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Tracer.defineEvents();
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            Wrapper.Fini();
            Wrapper.SetOptions(Wrapper.EXTRAE_DISABLE_ALL_OPTIONS);
            // ** MonitorExit[var0] (shouldn't be in output)
            Tracer.generateMasterPackage();
            Tracer.transferMasterPackage();
            Tracer.generateTrace();
            Tracer.cleanMasterPackage();
            return;
        }
    }

    public static int getSizeByEventType(int type) {
        int size = 0;
        for (Event task : Event.values()) {
            if (task.getType() != type) continue;
            ++size;
        }
        return size;
    }

    private static void defineEvents() {
        if (debug) {
            logger.debug("SignatureToId size: " + CoreManager.SIGNATURE_TO_ID.size());
        }
        Map<String, Integer> signatureToId = CoreManager.SIGNATURE_TO_ID;
        int size = Tracer.getSizeByEventType(8000001) + 1;
        long[] values = new long[size];
        int offset = Event.values().length;
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (Event task : Event.values()) {
            if (task.getType() != 8000001) continue;
            values[i] = task.getId();
            descriptionValues[i] = task.getSignature();
            if (debug) {
                logger.debug("Tracing[API]: Api Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000001, apiDesc, values, descriptionValues);
        size = signatureToId.entrySet().size() + 1;
        values = new long[size];
        descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        i = 1;
        for (Map.Entry<String, Integer> entry : signatureToId.entrySet()) {
            String methodName;
            String signature = entry.getKey();
            Integer methodId = entry.getValue();
            values[i] = methodId + 1;
            descriptionValues[i] = methodName = signature.substring(0, signature.indexOf(40));
            if (debug) {
                logger.debug("Tracing[TASKS_FUNC_TYPE] Event [i,methodId]: [" + i + "," + methodId + "] => value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000000, taskDesc, values, descriptionValues);
        size = Tracer.getSizeByEventType(8000003) + 1;
        values = new long[size];
        descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        i = 1;
        for (Event task : Event.values()) {
            if (task.getType() != 8000003) continue;
            values[i] = task.getId();
            descriptionValues[i] = task.getSignature();
            if (debug) {
                logger.debug("Tracing[TASK_TRANSFERS]: Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000004, dataTransfersDesc, values, descriptionValues);
        size = 0;
        values = new long[size];
        descriptionValues = new String[size];
        Wrapper.defineEventType(8000002, taskIdDesc, values, descriptionValues);
    }

    public static void generateMasterPackage() {
        if (debug) {
            logger.debug("Tracing: generating master package");
        }
        String scriptDir = System.getProperty("it.script.dir");
        ProcessBuilder pb = new ProcessBuilder(scriptDir + File.separator + TRACE_SCRIPT, "package", ".", "master");
        pb.environment().remove("LD_PRELOAD");
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e) {
            logger.error("Error generating master package", e);
            return;
        }
        if (debug) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err);
            outputGobbler.start();
            errorGobbler.start();
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                logger.error("Error generating master package, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            logger.error("Error generating master package (interruptedException) : " + e.getMessage());
        }
    }

    public static void transferMasterPackage() {
        if (debug) {
            logger.debug("Tracing: Transferring master package");
        }
        Semaphore sem = new Semaphore(0);
        TracingCopyListener tracingListener = new TracingCopyListener(sem);
        String filename = "master_compss_trace.tar.gz";
        DataLocation source = DataLocation.getLocation(Comm.appHost, filename);
        DataLocation target = DataLocation.getLocation(Comm.appHost, traceDirPath + filename);
        COMPSsNode node = Comm.appHost.getNode();
        tracingListener.addOperation();
        node.obtainData(new LogicalData("tracing master package"), source, target, new LogicalData("tracing master package"), new TracingCopyTransferable(), tracingListener);
        tracingListener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            logger.error("Error waiting for tracing files in master to get saved");
        }
    }

    public static void generateTrace() {
        if (debug) {
            logger.debug("Tracing: Generating trace");
        }
        String scriptDir = System.getProperty("it.script.dir");
        String appName = System.getProperty("it.appName");
        ProcessBuilder pb = new ProcessBuilder(scriptDir + File.separator + TRACE_SCRIPT, "gentrace", System.getProperty("it.appLogDir"), appName);
        Process p = null;
        pb.environment().remove("LD_PRELOAD");
        try {
            p = pb.start();
        }
        catch (IOException e) {
            logger.error("Error generating trace", e);
            return;
        }
        if (debug) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err);
            outputGobbler.start();
            errorGobbler.start();
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                logger.error("Error generating trace, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            logger.error("Error generating trace (interruptedException) : " + e.getMessage());
        }
    }

    public static void cleanMasterPackage() {
        String filename = "master_compss_trace.tar.gz";
        DataLocation source = DataLocation.getLocation(Comm.appHost, filename);
        if (debug) {
            logger.debug("Tracing: Removing tracing master package: " + source.getPath());
        }
        File f = null;
        try {
            f = new File(source.getPath());
            f.delete();
        }
        catch (Exception e) {
            logger.error("Unable to remove tracing temporary files of master node.");
        }
    }

    private static class TraceHost {
        private boolean[] slots;
        private int numFreeSlots;
        private int nextSlot;

        public TraceHost(int nslots) {
            this.slots = new boolean[nslots];
            this.numFreeSlots = nslots;
            this.nextSlot = 0;
        }

        public int getNextSlot() {
            if (this.numFreeSlots-- > 0) {
                while (this.slots[this.nextSlot]) {
                    this.nextSlot = (this.nextSlot + 1) % this.slots.length;
                }
                this.slots[this.nextSlot] = true;
                return this.nextSlot;
            }
            return -1;
        }

        public void freeSlot(int slot) {
            this.slots[slot] = false;
            this.nextSlot = slot;
            ++this.numFreeSlots;
        }
    }

    public static enum Event {
        STATIC_IT(1, 8000001, "Loading Runtime"),
        START(2, 8000001, "Start"),
        STOP(3, 8000001, "Stop"),
        TASK(4, 8000001, "Execute Task"),
        NO_MORE_TASKS(5, 8000001, "Waiting for tasks end"),
        OPEN_FILE(6, 8000001, "Waiting for open file"),
        GET_FILE(7, 8000001, "Waiting for get file"),
        GET_OBJECT(8, 8000001, "Waiting for get object"),
        DELETE(9, 8000001, "Delete File"),
        TASK_RUNNING(10, 8000001, "Task Running"),
        SCHEDULE_TASK(11, 8000001, "Task Dispatcher: Scheduling task"),
        FINISHED_TASK(12, 8000001, "Task Dispatcher: Finished task"),
        RESCHEDULE_TASK(13, 8000001, "Task Dispatcher: Rescheduling task"),
        NEW_WAITING_TASK(14, 8000001, "Task Dispatcher: New waiting task"),
        DEBUG_TASK(15, 8000001, "Task Dispatcher: Debug task"),
        DEFAULT_TASK(16, 8000001, "Task Dispatcher: Default task"),
        DEBUG(17, 8000001, "Access Processor: Debug"),
        ANALYSE_TASK(18, 8000001, "Access Processor: Analyse task"),
        UPDATE_GRAPH(19, 8000001, "Access Processor: Update graph"),
        WAIT_FOR_TASK(20, 8000001, "Access Processor: Wait for task"),
        END_OF_APP(21, 8000001, "Access Processor: End of app"),
        ALREADY_ACCESSED(22, 8000001, "Access Processor: Already accessed"),
        REGISTER_DATA_ACCESS(23, 8000001, "Access Processor: Register data access"),
        TRANSFER_OPEN_FILE(24, 8000001, "Access Processor: Transfer open file"),
        TRANSFER_RAW_FILE(25, 8000001, "Access Processor: Transfer raw file"),
        TRANSFER_OBJECT(26, 8000001, "Access Processor: Transfer object"),
        NEW_VERSION_SAME_VALUE(27, 8000001, "Access Processor: New version same value"),
        IS_OBJECT_HERE(28, 8000001, "Access Processor: Is object here"),
        SET_OBJECT_VERSION_VALUE(29, 8000001, "Access Processor: Set object version value"),
        GET_LAST_RENAMING(30, 8000001, "Access Processor: Get last renaming"),
        BLOCK_AND_GET_RESULT_FILES(31, 8000001, "Access Processor: Block and get result files"),
        UNBLOCK_RESULT_FILES(32, 8000001, "Access Processor: Unblock result files"),
        SHUTDOWN(33, 8000001, "Access Processor: Shutdown"),
        GRAPHSTATE(34, 8000001, "Access Processor: Graphstate"),
        TASKSTATE(35, 8000001, "Access Processor: Taskstate"),
        DELETE_FILE(36, 8000001, "Access Processor: Delete file");

        private final int id;
        private final int type;
        private final String signature;

        private Event(int id, int type, String signature) {
            this.id = id;
            this.type = type;
            this.signature = signature;
        }

        public int getId() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

