/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.stage;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.nio.NIOProperties;
import es.bsc.comm.stage.Stage;
import es.bsc.comm.stage.Transfer;
import es.bsc.comm.util.Serializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class Submission
extends Transfer {
    private static int tokens = NIOProperties.MAX_SENDS;
    private static LinkedList<InternalConnection> pausedConnections = new LinkedList();
    protected InputStream streamIn;
    private boolean hasToken = false;
    protected Stage.Token token;

    public Submission(Transfer.Type type, byte[] array) {
        super(true);
        this.type = type;
        this.destination = Transfer.Destination.ARRAY;
        this.array = array;
        this.remainingSize = 0L;
    }

    public Submission(Transfer.Type type, Object o) {
        super(true);
        this.type = type;
        this.destination = Transfer.Destination.OBJECT;
        this.object = o;
        this.remainingSize = 0L;
    }

    public Submission(String name) {
        super(true);
        this.type = Transfer.Type.DATA;
        this.destination = Transfer.Destination.FILE;
        this.fileName = name;
        this.remainingSize = 0L;
    }

    private void setSize() {
        long length = 0L;
        if (this.destination == Transfer.Destination.OBJECT || this.destination == Transfer.Destination.ARRAY) {
            length = this.array.length;
        } else if (this.destination == Transfer.Destination.FILE) {
            File f = new File(this.fileName);
            length = f.length();
        }
        this.setSize(length);
    }

    private void openStream() {
        try {
            if (this.destination == Transfer.Destination.FILE) {
                this.streamIn = new FileInputStream(this.fileName);
            } else {
                if (this.destination == Transfer.Destination.OBJECT) {
                    this.array = Serializer.serialize(this.object);
                }
                this.streamIn = new ByteArrayInputStream(this.array);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception openning stream for " + this, e);
        }
    }

    public void loadFirstToken() throws IOException {
        int available = this.streamIn.available();
        int tokenSize = Math.min(10240, available + 16);
        byte[] content = new byte[tokenSize];
        ByteBuffer bb = ByteBuffer.wrap(content);
        bb.putLong(this.totalSize);
        bb.putInt(this.type.ordinal());
        bb.putInt(this.destination.ordinal());
        this.streamIn.read(content, 16, tokenSize - 16);
        this.remainingSize -= (long)(tokenSize - 16);
        if (this.remainingSize == 0L) {
            this.closeStream();
        }
        this.token = new Stage.Token(content);
    }

    public void loadNextToken() throws IOException {
        int available = this.streamIn.available();
        int tokenSize = Math.min(10240, available);
        byte[] content = new byte[tokenSize];
        this.streamIn.read(content, 0, tokenSize);
        this.remainingSize -= (long)tokenSize;
        if (this.remainingSize == 0L) {
            this.closeStream();
        }
        this.token = new Stage.Token(content);
    }

    private void closeStream() {
        try {
            this.streamIn.close();
        }
        catch (IOException e) {
            LOGGER.error("Error closing input stream on connection " + this, e);
        }
    }

    @Override
    public Transfer.Direction getDirection() {
        return Transfer.Direction.SEND;
    }

    @Override
    public void start(InternalConnection connection, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) throws IOException {
        --tokens;
        this.hasToken = true;
        this.openStream();
        this.setSize();
        this.loadFirstToken();
        this.sendTokenPacket(this.token, transmit);
    }

    @Override
    public void progress(InternalConnection connection, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) throws IOException {
        this.sendToken(this.token, transmit);
        while (this.token.isCompletelyRead() && this.remainingSize > 0L) {
            this.loadNextToken();
            this.sendToken(this.token, transmit);
        }
    }

    @Override
    public boolean checkViability(boolean closedCommunication, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) throws NIOException {
        if (!closedCommunication) {
            return tokens > 0;
        }
        throw new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, new Exception("Channel was already closed for connection " + this));
    }

    @Override
    public void pause(InternalConnection ic) {
        pausedConnections.add(ic);
    }

    @Override
    public boolean isComplete(LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) {
        return this.sizeInit && this.remainingSize == 0L && transmit.isEmpty();
    }

    @Override
    public void notifyCompletion(Connection c, EventManager<?> em) {
        em.writeFinished(c, this);
        ++tokens;
        this.hasToken = false;
        if (pausedConnections.size() > 0) {
            InternalConnection ic = pausedConnections.removeFirst();
            ic.resume();
        }
    }

    @Override
    public void notifyError(Connection c, EventManager<?> em, CommException exc) {
        em.notifyError(c, this, exc);
        if (this.hasToken) {
            ++tokens;
            this.hasToken = false;
            if (pausedConnections.size() > 0) {
                InternalConnection ic = pausedConnections.removeFirst();
                ic.resume();
            }
        }
    }
}

