/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.commands.Data;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;

public class NIOParam
implements Externalizable {
    private ITExecution.ParamType type;
    private boolean preserveSourceData;
    private boolean writeFinalValue;
    private Object value;
    private Data data;

    public NIOParam() {
    }

    public NIOParam(ITExecution.ParamType type, boolean preserveSourceData, boolean writeFinalValue, Object value, Data data) {
        this.type = type;
        this.value = value;
        this.preserveSourceData = preserveSourceData;
        this.writeFinalValue = writeFinalValue;
        this.data = data;
    }

    public ITExecution.ParamType getType() {
        return this.type;
    }

    public boolean isPreserveSourceData() {
        return this.preserveSourceData;
    }

    public boolean isWriteFinalValue() {
        return this.writeFinalValue;
    }

    public Object getValue() {
        return this.value;
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = (ITExecution.ParamType)((Object)in.readObject());
        this.preserveSourceData = in.readBoolean();
        this.writeFinalValue = in.readBoolean();
        this.value = in.readObject();
        try {
            this.data = (Data)in.readObject();
        }
        catch (OptionalDataException e) {
            this.data = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeBoolean(this.preserveSourceData);
        out.writeBoolean(this.writeFinalValue);
        out.writeObject(this.value);
        if (this.data != null) {
            out.writeObject(this.data);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[PARAM");
        sb.append("[TYPE = ").append((Object)this.type).append("]");
        sb.append("[PRESERVE SOURCE DATA = ").append(this.preserveSourceData).append("]");
        sb.append("[WRITE FINAL VALUE = ").append(this.writeFinalValue).append("]");
        sb.append("[VALUE = ").append(this.value).append("]");
        sb.append("[DATA ").append(this.data).append("]");
        sb.append("]");
        return sb.toString();
    }
}

