/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio;

import integratedtoolkit.nio.NIOParam;
import integratedtoolkit.types.job.Job;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;

public class NIOTask
implements Externalizable {
    public String lang;
    public String installDir;
    public String libPath;
    public String appDir;
    public String classPath;
    public boolean workerDebug;
    private String className;
    private String methodName;
    private boolean hasTarget;
    private LinkedList<NIOParam> params;
    private int taskId;
    private int taskType;
    private int jobId;
    private Job.JobHistory hist;
    private int transferGroupId;
    private int numParams;

    public NIOTask() {
    }

    public NIOTask(String lang, String installDir, String libPath, String appDir, String classPath, boolean workerDebug, String className, String methodName, boolean hasTarget, LinkedList<NIOParam> params, int numParams, int taskId, int taskType, int jobId, Job.JobHistory hist, int transferGroupId) {
        this.lang = lang;
        this.installDir = installDir;
        this.libPath = libPath;
        this.appDir = appDir;
        this.classPath = classPath;
        this.workerDebug = workerDebug;
        this.className = className;
        this.methodName = methodName;
        this.hasTarget = hasTarget;
        this.params = params;
        this.taskType = taskType;
        this.taskId = taskId;
        this.jobId = jobId;
        this.hist = hist;
        this.numParams = numParams;
        this.transferGroupId = transferGroupId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isHasTarget() {
        return this.hasTarget;
    }

    public LinkedList<NIOParam> getParams() {
        return this.params;
    }

    public int getJobId() {
        return this.jobId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public Job.JobHistory getHist() {
        return this.hist;
    }

    public int getNumParams() {
        return this.numParams;
    }

    public int getTransferGroupId() {
        return this.transferGroupId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lang = (String)in.readObject();
        this.installDir = (String)in.readObject();
        this.libPath = (String)in.readObject();
        this.appDir = (String)in.readObject();
        this.classPath = (String)in.readObject();
        this.workerDebug = in.readBoolean();
        this.className = (String)in.readObject();
        this.methodName = (String)in.readObject();
        this.hasTarget = in.readBoolean();
        this.params = (LinkedList)in.readObject();
        this.taskType = in.readInt();
        this.taskId = in.readInt();
        this.jobId = in.readInt();
        this.hist = (Job.JobHistory)((Object)in.readObject());
        this.numParams = in.readInt();
        this.transferGroupId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lang);
        out.writeObject(this.installDir);
        out.writeObject(this.libPath);
        out.writeObject(this.appDir);
        out.writeObject(this.classPath);
        out.writeBoolean(this.workerDebug);
        out.writeObject(this.className);
        out.writeObject(this.methodName);
        out.writeBoolean(this.hasTarget);
        out.writeObject(this.params);
        out.writeInt(this.taskType);
        out.writeInt(this.taskId);
        out.writeInt(this.jobId);
        out.writeObject((Object)this.hist);
        out.writeInt(this.numParams);
        out.writeInt(this.transferGroupId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[TASK ");
        sb.append("[LANG= ").append(this.lang).append("]");
        sb.append("[TASK TYPE= ").append(this.taskType).append("]");
        sb.append("[TASK ID= ").append(this.taskId).append("]");
        sb.append("[JOB ID= ").append(this.jobId).append("]");
        sb.append("[HISTORY= ").append((Object)this.hist).append("]");
        sb.append("[CLASS= ").append(this.className).append("]");
        sb.append("[METHOD= ").append(this.methodName).append("]");
        sb.append(" [PARAMS ");
        for (NIOParam param : this.params) {
            sb.append(param);
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

